### 模块描述

SRT3906 为 6 通道热电偶（TC）输入模块，其还具备功能：传感器类型参数配置、滤波速率选择和诊断模块参数配置是否有效、通讯状态是否正常。SRT3906 共占输入7word 和输出 3word，模块需配合 SRT 系列耦合器使用，IO 模块无法单独使用；本文描述的模块功能均在 SRT3906 模块与耦合器正常通讯的前提下实现（1word=2byte）。

模块参数配置时注意：在 plc 初始化程序中先设置模块参数，再将耦合器的参数配置位使能，参数配置才可生效；二次修改模块参数配置需要模块断电重启一次才可生效。

#### SRT3906 模块地址表

| **输入输出信号所占 word 大小** | **以 word 为单位划分** |
|---|---|
| 输入（CPU 模块←SRT3906 模块）（7word） | 0 | 1~6 |
| 状态字（见表 1-3） | 数据字（见表 1-4） |
| 输出（CPU 模块→SRT3906 模块）（3word） | 0~2 |
| 控制字（见表 1-5） |

#### 状态字详细说明

|  | **Bit15-Bit2** | **Bit1** | **Bit0** |
|---|---|---|---|
| Word0 | 保留 | 模块参数配置位\[2\] | 模块通讯状态位\[1\] |

\[1\]：通讯状态位  
0：通讯状态正常；1：通讯状态故障。  
\[2\]：参数配置位  
0：未配置参数；1：配置参数有效。

#### 数据字详细说明

|  | **Bit15-Bit0** |
|---|---|
| Word1 | 0 通道数据输入值\[3\] |
| Word2 | 1 通道数据输入值 |
| Word3 | 2 通道数据输入值 |
| Word4 | 3 通道数据输入值 |
| Word5 | 4 通道数据输入值 |
| Word6 | 5 通道数据输入值 |

#### 温度输入规则

通道温度显示值为摄氏度温度值（分辨率 0.1℃）的 10 倍（数据格式为有符号十进制）。

控制字详细说明

|  | Bit15 | Bit14 | Bit13~Bit12 | Bit11-Bit8 | Bit7 | Bit6 | Bit5~Bit4 | Bit3-Bit0 |
|---|---|---|---|---|---|---|---|---|
| Word0 | CH2 通道使能 | CH2 冷端补偿 | CH2 数据输出速率 | CH2 传感器类型配置 | CH1 通道使能\[7\] | CH1 冷端补偿\[6\] | CH1 数据输出速率\[5\] | CH1 传感器类型配置\[4\] |
| Word1 | CH4 通道使能 | CH4 冷端补偿 | CH4 数据输出速率 | CH4 传感器类型配置 | CH3 通道使能 | CH3 冷端补偿 | CH3 数据输出速率 | CH3 传感器类型配置 |
| Word2 | CH6 通道使能 | CH6 冷端补偿 | CH6 数据输出速率 | CH6 传感器类型配置 | CH5 通道使能 | CH5 冷端补偿 | CH5 数据输出速率 | CH5 传感器类型配置 |

SRT3906 支持 9 种传感器类型切换，参数配置值高低位说明：左边为高位，右边为低位。（例0001：最左边第一个‘0’为最高位 Bit3，最右边的‘1’则为最低位 Bit0，\[5\] \[6\] \[7\] 同理）  
① 0000:K 型（默认），测温范围 -200~1372℃；  
② 0001:J 型，测温范围 -210~1200℃；  
③ 0010:T 型，测温范围 -250~400℃；  
④ 0011:E 型，测温范围 -250~1000℃；  
⑤ 0100:N 型，测温范围 -200~1300℃；  
⑥ 0101:S 型，测温范围 -20~1767℃；  
⑦ 0110:R 型，测温范围 -20~1767℃；  
⑧ 0111:B 型，测温范围 600~1820℃；  
⑨ 1000:C 型，测温范围 0~2316℃。

SRT3906 支持 4 种滤波时间配置  
① 00：200ms（默认）；  
② 01：1000ms；  
③ 10：100ms；  
④ 11：50ms 。  
\[6\]：SRT3906 支持冷端补偿  
① 0：使能（默认）；  
② 1：失能。  
注意：选项\[6\]默认开启的冷端补偿为 SRT3906 模块内部补偿，外部温度补偿需要用户在模组热机运行（约上电 10 分钟之后）时与实际温度比较，模块采集温度一般比实际温度偏低约 2~3℃。

\[7\]：SRT3906 支持通道使能  
① 0：使能（默认）；  
② 1：失能。