### 模块描述

SRT5032 为 2 通道高速计数模块，其还具备功能：比较输出状态显示、不合理数据下发报警、诊断模块参数配置是否有效和通讯状态是否正常。SRT5032 共占输入 13word 和输出 15word，模块需配合 SRT 系列耦合器使用，IO 模块无法单独使用； 本文描述的模块功能均在 SRT5032 模块与耦合器正常通讯的前提下实现（1word=2byte）。

注意：此版本耦合器上电后仅可更改一次模块参数配置，若要再次修改配置则需断电重启。

#### 模块地址表

| 上行下行数据所占 word 大小 | 以 word 为单位划分 |
|---|---|
| 上行（SRT5032 模块→CPU 模块）（13word） | 0 | 1~12 |
| 状态字 | 数据输入字 |
| 下行（CPU 模块→SRT5032 模块）（15word） | 0 | 1~14 |
| 控制字 | 数据输出字 |

#### 状态字详细说明

|  | Bit7-Bit2 | Bit1 | Bit0 |
|---|---|---|---|
| Word0 | 保留 | 参数配置位\[2\] | 通讯状态位\[1\] |
|  | Bit15 | Bit14 | Bit13-Bit12 | Bit11 | Bit10 | Bit9-Bit8 |
| Word0 | CH2环形值报警位 | CH2数据下发位 | CH2比较输出状态 | CH1环形值报警位\[5\] | CH1数据下发位\[4\] | CH1比较输出状态\[3\] |

通讯状态位  
该位表示模块的实时通讯状态，状态如下：  
0：通讯正常；1：通讯故障。  
参数配置位  
该位表示模块的参数配置状态，状态如下：  
0：未配置参数；1：配置参数有效。  
比较输出状态  
该功能占用 2 位数据，反馈模块的当前计数值与比较设定值之间的大小关系， 比较状态实时更新不作停留或状态保持，状态对应关系如下：  
00（十进制 0）：无；  
01（十进制 1）：计数当前值  
10（十进制 2）：计数当前值=比较设定值；  
11（十进制 3）：计数当前值&gt;比较设定值。  
数据下发位  
全称为数据下发不合理报警，若用户在计数启动后对‘数据输出字’的Word1~Word12 进行了修改，将会触发数据下发不合理报警，不合理报警状态对应关系如下： 0：正常；1：数据下发不合理报警。  
环形值报警位  
全称为环形计数值设置不合理报警，此功能仅在脉冲功能下有效，若用户设置的环形计数值等于计数初始值时，将会触发环形值不合理报警，此时若启动计数，‘数据输入字’中的脉冲计数值将等于计数初始值，其不合理报警状态如下：  
0：正常；1：环形计数值设置不合理报警。

#### 数据输入字详细说明

|  | Bit15-Bit0 |
|---|---|
| Word1 | CH1，在脉冲功能下：反馈脉冲计数值\[6\]在距离功能下：反馈距离值\[6\] |
| Word2 |
| Word3 | CH1，在脉冲功能下：反馈频率\[7\]在距离功能下：反馈转速\[7\] |
| Word4 |
| Word5 | CH1锁存输入值或普通输入值 \[8\] |
| Word6 |
| Word7 | CH2，在脉冲功能下：反馈脉冲计数值在距离功能下：反馈距离值 |
| Word8 |
| Word9 | CH2，在脉冲功能下：反馈频率在距离功能下：反馈转速 |
| Word10 |
| Word11 | CH2锁存输入值或普通输入值 |
| Word12 |

SRT5032 的脉冲计数值或距离值详细如下：  
脉冲计数值与距离值两个功能为复用功能，用户只能选择其中一种功能使用。  
① 在脉冲功能下：反馈脉冲计数值，数值范围：0~2^32-1 或计数器初始值~环形计数分辨率×计数倍率-1；  
② 在距离功能下：反馈距离值（单位 um），数值范围：0~2^31-1，由于距离的计算是跟脉冲计数值和 p/mm有关系的，公式：脉冲计数值÷p/mm×1000=距离值（um），所以要注意距离值不要超出 0~2^31-1 范围，如若超出，距离值则会显示 2^31-1。  
SRT5032 的频率或转速详细如下：  
频率与转速两个功能为复用功能，用户只能选择其中一种功能使用。  
① 在脉冲功能下：反馈频率，数值范围：0~2^32-1；  
② 在距离功能下：反馈转速，数值范围：0~2^32-1（单位 r/min），注意计算转速跟编码器分辨率数值有关，若分辨率数值设置为 0，转速计算结果将等于 2^32-1 以示提醒。（两者由于考虑到可能会出现小数值，最终结果=反馈值÷100）  
SRT5032 的锁存输入或普通输入详细如下：  
锁存输入与普通输入两个功能为复用功能，用户只能选择其中一种功能使用。  
① 默认输入为锁存输入，数值范围：0~2^32-1，其又分为硬锁存和软锁存。硬锁存由外部信号触发，输入信号为通用型，最低触发电压为 4.5VDC；软锁存是由‘数据输出字’决定；  
② 普通输入只占 1 位数据，如何切换到该功能在‘数据输出字’中有说明。

#### 控制字（配置参数）详细说明

|  | Bit15-Bit8 | Bit7-Bit0 |
|---|---|---|
| Word0 | CH2 计数器模式 | CH1 计数器模式\[9\] |

SRT5032 支持 6 种计数器模式配置，配置参数如下：（以 byte 进行控制编程）

0：2 相输入相位差脉冲\[1 倍\]（默认）；

![](https://resource.helplook.net/docker_production/3648ne/article/Un1SRrvA/image1.jpeg)

1：2 相输入相位差脉冲\[2 倍\]；

![](https://resource.helplook.net/docker_production/3648ne/article/Un1SRrvA/image2.jpeg)

2：2 相输入相位差脉冲\[4 倍\]；

![](https://resource.helplook.net/docker_production/3648ne/article/Un1SRrvA/image3.jpeg)

3：1 相 2 输入加减算脉冲；

![](https://resource.helplook.net/docker_production/3648ne/article/Un1SRrvA/image4.jpeg)

4：1 相 1 输入硬增·减计数；

![](https://resource.helplook.net/docker_production/3648ne/article/Un1SRrvA/image5.jpeg)

5：1 相 1 输入软增·减计数。

![](https://resource.helplook.net/docker_production/3648ne/article/Un1SRrvA/image6.jpeg)

软增减计数的控制由‘数据输出字’中的 Word14 完成。

数据输出字详细说明

|  | Bit15-Bit0 |
|---|---|
| Word1 | CH1 输出用比较设定值\[10\] |
| Word2 |
| Word3 | CH2 输出用比较设定值\[10\] |
| Word4 |
| Word5 | CH1，在脉冲功能下：计数初始值\[11\]在距离功能下：距离起点设置\[11\] |
| Word6 |
| Word7 | CH2，在脉冲功能下：计数初始值\[11\]在距离功能下：距离起点设置\[11\] |
| Word8 |
| Word9 | CH1，在脉冲功能下：写入环形计数值\[12\]在距离功能下：编码器分辨率\[12\] |
| Word10 | CH2，在脉冲功能下：写入环形计数值\[12\]在距离功能下：编码器分辨率\[12\] |
| Word11 | CH1，在距离功能下，写入每移动 1 毫米所产生的脉冲数，才能计算出移动距离\[13\] |
| Word12 | CH2，在距离功能下，写入每移动 1 毫米所产生的脉冲数，才能计算出移动距离\[13\] |
|  | Bit7 | Bit6 | Bit5 | Bit4 | Bit3 | Bit2 | Bit1 | Bit0 |
| Word13 | CH1 软锁存输入\[21\] | CH1 普通输入使能\[20\] | CH1普通输出\[19\] | CH1 普通输出使能\[18\] | CH1 比较输出复位\[17\] | CH1Z 相清零\[16\] | CH1功能切换\[15\] | CH1计数启动\[14\] |
|  | Bit15 | Bit14 | Bit13 | Bit12 | Bit11 | Bit10 | Bit9 | Bit8 |
| Word13 | CH2 软锁存输入 | CH2 普通输入使能 | CH2普通输出 | CH2 普通输出使能 | CH2 比较输出复位 | CH2Z 相清零 | CH2功能切换 | CH2计数启动 |
|  | Bit15-Bit10 | Bit9 | Bit8 | Bit7-Bit2 | Bit1 | Bit0 |
| Word14 | 保留 | CH2 所有反馈值复位 | CH2 的加/减指令 | 保留 | CH1 所有反馈值复位\[23\] | CH1 的加/减指令\[22\] |

输出用比较设定值：  
用户可根据需要设置，用于和当前计数值作比较，比较输出状态对应关。  
① 在脉冲功能下，只跟脉冲相关，设定范围 0~2^32-1；  
② 在距离功能下，只跟距离有关，设定范围 0~2^31-1，距离的单位是 um。  
计数初始值和距离起点设置值：  
用户可根据需要设置计数初始值或距离的起点，为复用功能。  
① 在脉冲功能下，用于计数值（当前值）的初始化，设定范围 0~2^32-1；  
② 在距离功能下，用于距离的起点设定，设定范围 0~2^31-1，距离的单位是 um。  
环形计数值和编码器分辨率的设置值： 该数值设定范围 1~65535，为复用功能。  
① 在脉冲功能下，该值若设置为 0 则表示线性计数，否则为环形计数；  
② 在距离功能下，需要正确设置编码器的分辨率，才能用于计算转速，反之若该值为 0，转速计算结果将等于 2^32-1 以示提醒。  
p/mm 数值设置：  
该数值设定范围 0~65535（单位为 p/mm），在距离功能下，计算距离时，需要写入每移动 1 毫米所产生的脉冲数才能计算出移动后的距离，若该值为 0，不管有没有脉冲信号输入，距离值都将等于用户设置的距离起点值，锁存值将等于 0；  
计数启动控制位：  
此位用来控制通道的计数启动或关闭，对应关系如下：  
0：关闭（默认）；1：启动。  
功能切换控制位：  
此位用来切换脉冲功能与距离功能，对应关系如下：  
0：脉冲功能（默认）；1：距离功能。  
注意：在数据输出字中，功能的切换是最先进行配置的，之后再设置相关数值才会是属于该功能的，比如：要使用距离功能，设置距离起点为 100um，p/mm 为 200p/mm 的配置， 配置顺序的第一步必须先切换到距离功能，距离起点和 p/mm 的配置不分先后。  
Z 相清零控制位：  
此位用来控制 Z 相清零的启动或关闭，对应关系如下：  
0：关闭（默认）；1：启动。  
比较输出复位控制位：  
此位用来控制比较输出信号和比较输出通道灯的复位，上升沿触发；  
普通输出使能控制位：  
此位用来切换比较输出或普通输出，对应关系如下：  
0：比较输出（默认）；1：普通输出。  
普通输出控制位：  
此位用来控制数字信号输出，模块输出为继电器输出，输出信号类型由 COM2 决定，对应关系如下：  
0：无输出；1：有输出。  
普通输入使能控制位：  
此位用来切换锁存输入和普通输入，对应关系如下：  
0：锁存输入（默认）；1：普通输入。  
锁存输入中的软锁存控制位：  
此位用来控制软锁存的触发，上升沿触发；  
加/减指令控制位：  
当用户使用 1 相 1 输入软增·减计数模式时，此位可以用来控制加减计数，状态如下：  
0：加计数；1：减计数。  
所有反馈值复位控制位：  
此位用来复位所有的反馈数据，上升沿触发； 对以上‘数据输出字’进行总结：  
1、计数启动之后，数据输出字 Word1~Word12 不允许修改，若用户在开启计数之后修改了数据输出字，将触发数据下发不合理报警，发生以上情况时，模块将无法正常计数而进入锁定状态，解决办法：首先确认数据输出字是否按需配置，确认无误后将计数启动控制位先设置为 关闭（置 0），等待状态报警消除后，再将计数启动控制位设置成启动（置 1）， 模块便按照设定的配置恢复正常计数；  
2、在脉冲功能下的环形计数值和计数初始值不能设置为相同，若两个值设置  
为相同，即会触发环形计数值设置不合理报警，解决办法：修改不合理的数值设置。  
补充：用户设置距离功能时，这两个值设置为相同也会触发报警，但在功能的切换完成之后，该报警会自动清除。