### 模块描述

#### SRT60x2 模块地址表

| **输入输出信号所占 word 大小** | **以 word 为单位划分** |
|---|---|
| 输出（CPU 模块→SRT60X2 模块）（23word） | 0~2 | 3~5 | 6~8 | 9~24 |
| 参数配置字（见表 1-3） | 读控制字（见表 1-4） | 写控制字（见表 1-5） | 有效输出（见表 1-6） |
| 输入（SRT60X2 模块→CPU 模块）（25word） | 0 | 1~6 | 7~22 |
| 状态字（见表 1-7） | 保留 | 有效输入（见表 1-8） |

#### 参数配置字详细说明

|  | Bit15-8 | Bit7-Bit2 | Bit1-Bit0 |
|---|---|---|---|
| Word0 | 从站 ID\[2\] | 保留 | 工作模式\[1\] |
|  | Bit13 | Bit11-Bit8 | Bit7-Bit6 | Bit5-Bit4 | Bit3-Bit2 | Bit1-Bit0 |
| Word1 | CH0 输出模式\[8\] | CH0 波特率\[7\] | CH0 校验位\[6\] | CH0 停止位 \[5\] | CH0 数据位 \[4\] | CH0 通信方式\[3\] |
| Word2 | CH1 输出模式 | CH1 波特率 | CH1 校验位 | CH1 停止位 | CH1 数据位 | CH1 通信方式 |

本说明书中所有序号高低位说明：左边为高位，右边为低位。（例 001：最左边第一个‘0’为最高位 Bit2，最右边的‘1’则为最低位 Bit0）

SRT6002 支持 3 种工作模式：  
① 00：主站模式（默认）；  
② 01：从站模式；  
③ 10：自由协议模式。

数据发送和读取说明：当前版本 SRT60X2 数据处理时发送和读取均是间隔 200ms 更新一次，例如下图演示：两片 SRT6012 工作在自由协议模式下，一片由 plc 控制数据发送（黑色线），另一片读取（红色线）读取值间隔 200ms 更新一次，读取值与 plc 发送间隔 400ms（发送 200ms+读取 200ms）。

![](https://resource.helplook.net/docker_production/3648ne/article/j6P5DZVs/688842d9145d5)

自由协议的详细功能说明：

当前版本配置为自由协议模式时，仅第 1 通道可用。  
数据发送:在 output 中用 Write Quantity 表示单次发送的字节数，16 个输出寄存器最多存放 32 字节数据。  
每个寄存器中的两个字节左边是低位，右边是高位，例如 1 号寄存器写入 0102:01 是第一个字节，02 是第二个字节。  
数据发送每次传输一次（Write Quantity+16 个输出寄存器中对应字节数量的数据），更改输出寄存器的数据或者改变字节长度都会重新发一帧。  
数据接收:上位机 INPUT 界面中,用 Read Quantity 表示一帧所含的字节数，Input 界面中的 16 个输入寄存器的数据传输方式与发送一致。  
SRT60X2 作为从站模式时的 Slave ID \[3\]：SRT60X2 支持 3 种通信方式：  
① SRT6002：RS485；  
② SRT6012：RS232；  
③ SRT6022：RS422 。  
注意：三个型号模块各自仅对应一种通信接口，用户无需配置，若对此部分进行配置将不会生效。

SRT60X2 数据位选择：  
① 00：8 位（默认）。  
SRT60X2 停止位选择：  
① 00：1 位（默认）；② 01：0.5 位；③ 10：1.5 位；④ 11：2 位。  
SRT60X2 校验位选择：  
① 00：无（默认）； ② 01：奇校验； ③ 10：偶校验。  
\[7\]：SRT60X2 波特率（kbps）选择：  
① 0000：9600（默认）；  
② 0011：4800；  
③ 0100：14400  
④ 0101：19200；  
⑤ 0110：38400；  
⑥ 0111：56000；  
⑦ 1000：57600；  
⑧ 1001：115200 。  
\[8\]：SRT60X2 数据下发模式：  
0：电平触发（默认）；  
1：上升沿触发

#### 读控制字详细说明

|  | Bit15-Bit8 | Bit7-Bit2 | Bit1 | Bit0 |
|---|---|---|---|---|
| Word3 | 从站地址\[11\] | 保留 | 使能 \[10\] | 通道 \[9\] |
| Word4 | 对象起始地址\[12\] |
| Word5 | 对象操作数量\[14\] | 读控制码\[13\] |

#### 写控制字详细说明

|  | Bit15-Bit8 | Bit7-Bit2 | Bit1 | Bit0 |
|---|---|---|---|---|
| Word6 | 从站地址\[17\] | 保留 | 使能 \[16\] | 通道 \[15\] |
| Word7 | 对象起始地址\[18\] |
| Word8 | 对象操作数量\[20\] | 写控制码\[19\] |

SRT60X2 的通道选择：  
① 0：CH1；  
② 1：CH2 。\[10\]\[16\]：SRT60X2 的读（写）使能：  
① 0：读（写）失能；  
② 1： 读 （ 写 ） 使 能 ； \[11\]\[17\]：SRT60X2 需要读、写从站的 ID 号\[12\]\[18\]：SRT60X2 需要读、写的对象起始地址  
\[13\]：SRT60X2 的读控制码：  
① 0x01：读线圈状态；  
② 0x02：读离散量输入  
③ 0x03：读保持寄存器  
④ 0x04：读输入寄存器  
SRT60X2 的对象操作数量（线圈类最多 32 个，寄存器类最多 16 个）  
SRT60X2 的写控制码：  
⑤ 0x05：写线圈  
⑥ 0x06：写寄存器

#### 有效输出详细说明

|  | Bit15-Bit0 |
|---|---|
| Word9～24 | 有效输出 |

#### 状态字详细说明

|  | Bit15-Bit2 | Bit1 | Bit0 |
|---|---|---|---|
| Word0 | 保留 | 模块参数配置位\[22\] | 模块通讯状态位\[ |

通讯状态位：  
0：通讯状态正常；1：通讯状态故障。  
\[22\]参数配置位：  
0：未配置参数；1：配置参数有效。

#### 有效输入详细说明

|  | Bit15-Bit0 |
|---|---|
| Word7～22 | 有效输入 |