### 增益切换

增益切换功能仅在位置和速度控制模式下有效，可由伺服内部状态或外部DI触发。使用增益切换，可以起到以下作用：

- 可以在电机使能静止时，位置锁定状态切换到较低增益，以抑制振动，降低静止噪音；
- 可以在电机停止过程中，位置整定时，切换到较高增益，以缩短定位时间；
- 可以在电机运行状态切换到较高增益，以获得更好的指令跟踪性能；
- 可以根据负载设备情况，通过外部信号切换不同的增益设置。

![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/686635bcd59ba.png)

举例：  
在 LED 固晶机应用场景下，对伺服有高速高精高响应需求，是快速定位 P2P 典型应用，采用增益切换功能，既可保证   
快速整定需求，又可降低伺服使能静止时的噪音。

| **参数组** | **增益切换调整步骤** | **不使用增益切换，手动增益调整** | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/6866362e952fd.png) | **第二增益与基础增益设为一样** | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/6866362f2d139.png) | **开启增益切换功能** | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/68663630353f6.png) | **静止时，调整第一组增益参数，消除静止噪音** |
|---|---|---|---|---|---|---|---|---|
| P06 | 速度比例增益1 | 35.0Hz |  |  | 27.0Hz |
| P06 | 速度积分增益1 | 16.00ms |  |  |  |
| P06 | 位置比例增益1 | 63.0Hz |  |  |  |
| P07 | 转矩滤波1 | 0.65ms |  |  | 0.84ms |
| P06 | 速度比例增益2 |  | 35.0Hz |  |  |
| P06 | 速度积分增益2 |  | 16.00ms |  |  |
| P06 | 位置比例增益2 |  | 63.0Hz |  |  |
| P07 | 转矩滤波2 |  | 0.65ms |  |  |
| P06 | 增益切换-模式选择 | 0 |  | 1 |  |
| P06 | 增益切换-条件选择 |  |  | 10 |  |
| P06 | 负载惯量比 | 通过惯量辨识获得 |  |  |  |

SV3系列伺服支持如下10种增益切换方式，其中1种是外部DI切换，9种是根据伺服内部运动状态切换：

0:第一增益固定 (PS)

1:使用外部DI进行切换 (PS)

2:转矩指令 (PS)

3:速度指令 (PS)

4:速度指令变化率 (PS)

5:速度指令高低速阈值 (PS)

6:位置偏差 (P)

7:有位置指令 (P)

8:定位未完成 (P)

9:实际速度 (P)

10:有位置指令+实际速度 (P)

其中，(P)代表该切换方式只支持位置控制模式，(PS)代表该切换方式支持位置控制和速度控制两种模式。下面针对9种伺服内部切换方式，进行进一步切换说明。

| **增益切换方式** | **切换方式变化图** |
|---|---|
| 2：转矩指令 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/6866368c285a8.png) |
| 3：速度指令 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/68663696c8d3d.png) |
| 4：速度指令变化率 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/6866369d6cce2.png) |
| 5：速度指令高低速阈值 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/686636a36eff2.png) |
| 6：位置偏差 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/686636aa7470b.png) |
| 7：位置指令 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/686636b600ae6.png) |
| 8：定位完成 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/686636bb584b1.png) |
| 9：实际速度 | ![](https://resource.helplook.net/docker_production/3648ne/article/gvTmimXq/686636c4dcef8.png) |
| 10：有位置指令+实际速度 | 方式7和方式9的结合，一般选择此方式，可以保证快速稳定整定到位 |

 

延迟时间“P06.17”只在第二增益切换到第一增益时有效。

 

| **功能码** | **P06.15-增益切换-模式设置** | **P06.16-增益切换-条件选择** | **P06.17-增益切换-延时** | **P06.18-增益切换-等级** | **P06.19-增益切换-时滞** | **P06.20-增益切换-时间** |
|---|---|---|---|---|---|---|
| 单位 | - | - | ms | - | - | ms |
| 默认值 | 1 | 0 | 5.0 | 50 | 30 | 3.0 |
| 最小值 | 0:第一增益固定，使用外部DI进行P/PI切换   1:第一增益和第二增益切换有效，切换条件为P06.16 | 0:第一增益固定 (PS)   1:使用外部DI进行切换 (PS)   2:转矩指令大 (PS)   3:速度指令大 (PS)   4:速度指令变化率大 (PS)   5:速度指令高低速阈值 (PS)   6:位置偏差大 (P)   7:有位置指令 (P)   8:定位未完成 (P)   9:实际速度 (P)   10:有位置指令+实际速度 (P) | 0 | 0 | 0 | 0 |
| 最大值 |  |  | 1000 | 20000 | 20000 | 1000 |
| 设定、生效方式 | 运行设定/立即生效 | 运行设定/立即生效 | 停机设定/立即生效 | 停机设定/立即生效 | 停机设定/立即生效 | 停机设定/立即生效 |