### 定位完成信号/定位接近信号

定位完成功能是指位置随动偏差满足用户设定的条件(P13.08)，可认为位置控制模式下定位结束。此时，伺服驱动器可   
输出位置到达（Coin）信号，上位机接收到该信号可确认伺服驱动器定位完成。

定位完成功能说明

![](https://resource.helplook.net/docker_production/3648ne/article/ns481pdl/6864f2429576d.png)

位置偏差相关信号

![](https://resource.helplook.net/docker_production/3648ne/article/ns481pdl/6864f250cd904.png)

当位置偏差满足条件(P13.09)时，伺服驱动器也可输出定位接近(FunOut.10)信号，通常上位机在确认位置到达前，可先接收到定位接近信号，为定位完成操作做准备。

使用定位完成/接近功能前，应对位置到达/定位接近的输出条件、阈值和窗口及保持时间进行设置。位置到达窗口时间和保持时间的原理如下图：

![](https://resource.helplook.net/docker_production/3648ne/article/ns481pdl/6864f26f977b1.png)

当定位完成输出选择有保持功能时，其设置值为 0 表示直到下一次收到位置指令前，定位完成信号一直保持有效。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P13 | 07 | 位置到达信号输出条件 | 位置偏差绝对值小于P13.08时输出位置偏差绝对值小于P13.08，且滤波后的位置指令为0时输出位置偏差绝对值小于P13.08，且滤波前的位置指令为0时输出位置偏差绝对值小于P13.08，且滤波前的位置指令为0时输出,至少保持P13.10设置时间有效 | - | 设置位置到达(COIN)/定位接近(NEAR)有效的条件 | 运行设定 | 立即生效 | 0 |
| P13 | 08 | 位置到达信号窗口 | 1~65535 | 编码器单位 | 设置位置到达 (COIN)有效时位置偏差绝对值的阈值 | 运行设定 | 立即生效 | 7 |
| P13 | 09 | 定位接近信号窗口 | 1~65535 | 编码器单位 | 设置定位接近 (NEAR) 有效时位置偏差绝对值的阈值 | 运行设定 | 立即生效 | 65535 |
| P13 | 10 | 位置到达信号保持时间 | 0~30000 | ms | 定位信号有效至少保持的时间 | 运行设定 | 立即生效 | 0 |
| P13 | 60 | 定位完成滤波时间 | 0~30000 | ms | 定位信号滤波时间，滤波后输出有效电平 | 运行设定 | 立即生效 | 0 |

- 定位接近信号窗口(P13.09)一般需大于位置到达信号窗口(P13.08)。
- 位置到达信号窗口(P13.08)只反映，定位完成有效时位置偏差绝对值的阈值，与定位精度无关。
- 速度前馈增益(P06.08) 设定值过大或低速运行时，将引起位置偏差绝对值较小，若P13.08 设定值过大，会导致定位完成一直有效，因此，为提高定位完成的有效性，请减小P13.08 设定值。
- 在位置到达信号窗口(P13.08)小，位置偏差也较小情况下，可通过设置P13.07变更定位完成信号的输出条件。
- 伺服使能无效时，定位完成信号(COIN)与定位接近信号(NEAR)输出无效。
- 使用定位完成和定位接近功能时，应将伺服驱动器的2个DO端子分别配置为DO功能10(FunOUT.10：NEAR，定位接近)和DO功能11(FunOUT.11：COIN，位置到达)并确定对应DO端子有效逻辑。

| **编码** | **名称** | **功能名** | **功能** |
|---|---|---|---|
| FunOut.10 | NEAR | 定位接近 | 有效，位置控制模式下，位置偏差绝对值满足P13.09设定条件，表明伺服定位接近。无效，位置控制模式下，伺服正处于定位接近过程中。 |
| FunOut.11 | COIN | 位置到达 | 有效，位置控制模式下，位置偏差绝对值满足P13.08设定条件，表明伺服位置到达。无效，位置控制模式下，伺服正处于定位完成过程中。 |