### 抱闸设置

抱闸用于在伺服系统未激活（如伺服系统断电）时，停止运动负载的非预期运动（如在重力作用下的掉落），防止伺服电机在断电后可能因为其自身重量或者受到外力而发生意外移动。

注意：

- 抱闸机构是非通电动作型的固定专用机构，不可用于制动用途，仅在使伺服电机保持停止状态时使用；
- 抱闸线圈无极性；
- 伺服电机停机后，应关闭伺服使能；
- 内置抱闸的电机运转时，抱闸可能会发出咔咔声，功能并无影响；
- 抱闸线圈通电时（抱闸开放状态），在轴端等部位可能发生磁通泄露，在电机附近使用磁传感器等仪器时，请注意此情况的发生可能性。

---

### 抱闸参数设置

对于带抱闸的应用场合，必须将抱闸使能开关（P05.12）设置为使能，并将伺服驱动器DO端子中的一个配置为功能17 (BK，抱闸控制)，并确定对应DO端子的有效逻辑。

根据伺服驱动器当前状态，抱闸机构的工作时序可分为两种：伺服驱动器正常状态抱闸时序、伺服驱动器故障状态抱闸时序。

| **P05.12-抱闸使能开关** |
|---|
| 可访问性 | 可读/可写 |
| 单位 | - |
| 默认值 | 1 |
| 最小值 | 0 |
| 最大值 | 1 |
| 设定、生效方式 | 运行设定/立即生效 |

抱闸输出功能编号

| **编码** | **名称** | **功能名** | **功能** |
|---|---|---|---|
| 17 | BK | 抱闸控制 | 无效，抱闸电源接通，抱闸动作，电机处于位置锁定状态；有效，抱闸电源断开，抱闸解除，电机可运动； |

---

### 伺服驱动器正常状态抱闸时序

正常状态的抱闸时序可分为电机静止和电机运动两种情况：

- 静止：电机实际转速低于30rpm；
- 运动：电机实际转速达到30rpm及以上。

（1）伺服电机静止时的抱闸时序

- 伺服使能由ON转为OFF时，若当前电机速度低于30rpm，则驱动器按静止抱闸时序动作；
- 抱闸输出由OFF置为ON后，在P05.13时间内，请勿输入位置/速度/转矩指令，否则会造成指令丢失或运行错误；
- 用于垂直轴时，机械运动部的自重或外力可能会引起机械轻微移动。伺服电机静止情况时，发生伺服使能OFF，抱闸输出立刻变为OFF，但在P05.14时间内，电机仍然处于通电状态，防止机械运动部由于自重或外力作用移动。

![](https://resource.helplook.net/docker_production/3648ne/article/bMk0Mpbw/6864d25cc9c07.png)

- 伺服使能ON时，抱闸输出被置为ON，同时电机进入通电状态；
- 抱闸接触部动作的延迟时间请参考相关规格；
- 从抱闸输出设为ON到输入指令，请间隔P05.13时间以上；
- 伺服电机静止情况(电机转速低于30rpm)下，伺服使能OFF时，抱闸输出同时被置为OFF，通过P05.14可以设定抱闸输出OFF后，电机进入非通电状态的延时。

P05.13抱闸松闸到可接收指令延时（停止状态）功能码

| **P05.13-抱闸松闸到可接收指令延时** |
|---|
| 可访问性 | 可读/可写 |
| 单位 | ms |
| 默认值 | 250 |
| 最小值 | 0 |
| 最大值 | 500 |
| 设定、生效方式 | 运行设定/立即生效 |

P05.14抱闸吸合零速保持时间（停止状态）功能码

| **P05.14-抱闸吸合零速保持时间** |
|---|
| 可访问性 | 可读/可写 |
| 单位 | ms |
| 默认值 | 150 |
| 最小值 | 1 |
| 最大值 | 1000 |
| 设定、生效方式 | 运行设定/立即生效 |

---

### 伺服电机运动时的抱闸时序

- 伺服使能由ON转为OFF时，若当前电机速度大于或等于30rpm，则驱动器按运动抱闸时序动作。
- 伺服使能由OFF置为ON时，在P05.13时间内，请勿输入位置/速度/转矩指令，否则会造成指令丢失或运行错误；
- 伺服电机运动时，发生伺服使能OFF，伺服电机进入零速停机状态，但抱闸输出需满足以下任一条件才被设为OFF。 
    - Ⅰ. P05.16时间未到，但电机已减速至P05.15；
    - Ⅱ. P05.16时间已到，但电机转速仍高于P05.15。
- 抱闸输出由ON变为OFF后，在50ms时间内，电机仍然处于通电状态，防止机械运动部由于自重或外力作用移动。

![](https://resource.helplook.net/docker_production/3648ne/article/bMk0Mpbw/6864d337382cd.png)

- 伺服使能ON时，抱闸输出被置为ON，同时电机进入通电状态；
- 抱闸接触部动作的延迟时间请参考相关规格。
- 从抱闸输出设为ON到输入指令，请间隔P05.13时间以上。
- 伺服电机运动情况下，伺服使能OFF时，通过P05.15和P05.16可以设定伺服使能OFF后，抱闸输出OFF的延时，在抱闸输出OFF后再延时50ms，电机才进入非通电状态。

P05.15抱闸吸合速度阈值

| **P05.15-抱闸吸合速度阈值** |
|---|
| 可访问性 | 可读/可写 |
| 单位 | rpm |
| 默认值 | 30 |
| 最小值 | 0 |
| 最大值 | 3000 |
| 设定、生效方式 | 运行设定/立即生效 |

P05.16-抱闸吸合时间阈值

| P05.16-抱闸吸合时间阈值 |
|---|
| 可访问性 | 可读/可写 |
| 单位 | ms |
| 默认值 | 500（ms） |
| 最小值 | 1 |
| 最大值 | 1000 |
| 设定、生效方式 | 运行设定/立即生效 |

---

### 伺服驱动器故障状态抱闸时序

伺服故障按照停机方式的不同，分为第1类故障(简称：NO.1)和第2类故障(简称：NO.2)，请查看“第6章 故障和警告处理”。伺服驱动器故障状态抱闸时序可分为以下2种情况：

- 发生第1类故障  
    抱闸DO输出条件与“伺服驱动器正常状态下，伺服电机运动时的抱闸时序”相同。即：抱闸输出需满足以下任一条件才被设为OFF： 
    - P05.16时间未到，但电机已减速至P05.15；
    - P05.16时间已到，但电机转速仍高于P05.15。
- 发生第2类故障  
    发生第2类故障且使能抱闸时，第2类故障停机方式被强制为“零速停机，自由运行状态”。

此时，伺服电机首先进行零速停机，当电机实际转速低于30rpm时，抱闸DO输出条件与“伺服驱动器正常状态下，伺服电机静止时的抱闸时序”相同，即：抱闸输出立刻变为OFF，但在P05.14时间内，电机仍然处于通电状态。