### 机械负载识别

对于伺服系统而言，机械负载是系统被控对象，是系统的重要组成部分；机械负载识别包括负载惯量、摩擦力和负载机械共振点等部分。伺服通过自动识别关键机械特性，对控制环路参数和补偿参数，自动进行合理设置，可实现满足应用需求的动态响应性能，大大减小了现场调试人员的调参压力。

![](https://resource.helplook.net/docker_production/3648ne/article/5vM5b0aP/68662cf02a92c.png)

通常，我们不太关注机械负载惯量的绝对值，而更加关心负载惯量与电机惯量的相对大小，所以一般以“惯量比”形式出现在控制环路中。

“负载惯量比”指：

![](https://resource.helplook.net/docker_production/3648ne/article/5vM5b0aP/68662d047bfc2.png)

负载惯量比是伺服系统的重要参数，正确设置负载惯量比有助于快速完成调试。

伺服驱动器内置了负载惯量辨识功能，可通过执行该算法实现负载惯量的自动识别。

惯量辨识自动识别方法：通过操作伺服驱动器面板上的按键使电机运动，实现惯量辨识，无需上位机的介入；

在下述条件时，有可能不能进行正常的机械负载识别，在这种条件下，请进行手动增益调整。

| **影响机械负载识别的因素** |
|---|
| 负载惯量 | 惯量不匹配，负载惯量比大于100倍    负载惯量不稳定，时变或者缓慢变化 |
| 机械特性 | 机械刚性极低，例如，皮带传动机构，皮带未张紧情况   运行过程中啮合齿隙过大或者正反转运行背隙过大等非线性因素，例如，齿轮传动机构，齿轮安装不同心情况 |
| 运动条件 | 运动速度小于150rpm   加减速转矩小于偏载重转矩或者小于粘滞摩擦转矩时   加速度小于3000rpm/s时 |

若实际负载惯量比很大，导致电机动作迟缓，此时可增大P1A组-“响应等级设定”后重新进行惯量辨识。

辨识过程中若发生振动，应立刻停止惯量辨识，降低P1A组-“响应等级设定”。

进行离线惯量辨识前，首先确认如下内容：

- 在机械限位开关间有正反各1圈以上的可运动行程：
- 进行离线惯量辨识前，请务必确保机械上已安装限位开关，防止惯量辨识过程中发生超程，造成事故！
- 若实际负载惯量比很大，预估大于电机惯量30倍以上，会出现惯量失配现象，导致电机动作迟缓，此时可采取以下两种措施：
- 预置负载惯量比为一较大的初始值，预置值建议以5.00倍为起始值，逐步递增至辨识随之更新为止；负载惯量比可通过面板设置“P06.10”，还可通过后台软件设置“P06组-负载惯量比”参数设定
- 通过后台适当增大驱动器“P1A高级调整-响应等级设定”，也可通过功能码“P1A.01”设置。

面板操作惯量辨识的一般流程如下：

![](https://resource.helplook.net/docker_production/3648ne/article/5vM5b0aP/68662e64ca50b.png)

惯量辨识采用正反三角波运动形式，程序已经默认了最优运动参数；用户可根据实际应用场景，通过微调运动参数设置，实现满足现场需求的辨识动作。辨识程序运动曲线和参数设置如下。

![](https://resource.helplook.net/docker_production/3648ne/article/5vM5b0aP/68662e80c2a0b.png)**自整定参数功能码**

| **功能码** | **P1A.06** | **P1A.07** | **P1A.08** | **P1A.09** |
|---|---|---|---|---|
| 名称 | 惯量辨识最大速度 | 惯量辨识加速时间 | 惯量辨识等待时间 | 惯量辨识转动圈数 |
| 可访问性 | 可读/可写 | 可读/可写 | 可读/可写 | 可读/可写 |
| 单位 | rpm | ms | ms | 圈 |
| 默认值 | 500 | 125 | 800 | 1.00 |
| 最小值 | 100 | 20 | 50 | 0.00 |
| 最大值 | 1000 | 800 | 10000 | 655.35 |
| 设定、生效方式 | 停机设定/立即生效 | 停机设定/立即生效 | 停机设定/立即生效 | 停机设定/立即生效 |
| 注释 | 离线惯量辨识相关参数设定，内部已经默认最佳值，一般情况下，无需设定 |