### 位置指令来源

位置控制模式时，首先应通过功能码P13.00设置位置指令来源

![](https://resource.helplook.net/docker_production/3648ne/article/d792TSg4/6864f00151c71.png)

| **功能码** | **名称** | **设定范围** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|
| P13 | 00 | 位置指令来源 | 0：脉冲指令   1：预设位置指令 | 设置位置指令来源。   其中脉冲指令为外部位置指令，预设位置指令为内部位置指令。 | 停机设定 | 立即生效 | 0 |

a) 位置指令来源为脉冲指令(P13.00=0)

选用脉冲指令时，请按以下操作得到正确的脉冲指令形态。

脉冲指令来源设置流程

![](https://resource.helplook.net/docker_production/3648ne/article/d792TSg4/6864f00154e9c.png)

**脉冲指令输入端子**

伺服驱动器有2组脉冲输入端子：

![](https://resource.helplook.net/docker_production/3648ne/article/d792TSg4/6864f0015f911.png)

- 低速脉冲输入端子(对应 PULSE+，PULSE-，SIGN+，SIGN-)，接受差分输入(输入脉冲最大频率为 500kpps)和集电极   
    开路输入(输入脉冲最大频率为 200kpps)。
- 高速脉冲输入端子(对应 HPULSE+，HPULSE-，HSIGN+，HSIGN-)，只接受差分输入(输入脉冲最大频率为 4Mpps)。

| **功能码** | **名称** | **设定范围** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|
| P13 | 13 | 脉冲指令高低速选择 | 0：低速   1：高速 | 设置脉冲指令的硬件输入端子。 | 停机设定 | 立即生效 | 0 |

脉冲输入规格

| **脉冲规格** | **最高输入频率** | **电压规格** | **顺向电流** |
|---|---|---|---|
| 高速脉冲 | 差分信号 | 4M | 5V |  |
| 低速脉冲 | 差分信号 | 500k | 5V |  |
| 集电极开路信号 | 200k | 24V |  |

**脉冲输入管脚滤波**

低速脉冲或高速脉冲的硬件输入端子需要设置一定的管脚滤波时间对输入脉冲指令进行滤波，防止干扰信号进入伺服驱动器造成电机误动作。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P07 | 74 | 低速脉冲指令滤波 | 0~255 | 25ns | 设置对低速脉冲的滤波时间常数。 | 停机设定 | 再次通电 | 30 |
| P07 | 75 | 高速脉冲指令滤波 | 0~255 | 25ns | 设置对高速脉冲的滤波时间常数。 | 停机设定 | 再次通电 | 3 |

若脉冲输入管脚滤波时间常数为t*F*，输入信号的最小宽度为t*min*，则输入信号与滤波后信号如下图所示。其中，滤波后信号相比于输入信号，将延迟t*F*。

示例：

![](https://resource.helplook.net/docker_production/3648ne/article/d792TSg4/6864f0015ca36.png)

脉冲输入管脚滤波时间tF需满足：tF≤(20%~25%)tmin。

已知输入脉冲的最大频率(或最小脉冲宽度)，滤波参数推荐值如下表所示

| **输入脉冲端子** | **相应功能码** | **输入脉冲最大频率/Hz** | **推荐滤波参数(单位：25ns)** |
|---|---|---|---|
| 低速脉冲输入端子 | P07.74 |  | 30 |
| 低速脉冲输入端子 | P07.74 | 167k~250k | 20 |
| 低速脉冲输入端子 | P07.74 | 250k~500k | 10 |
| 高速脉冲输入端子 | P07.75 | 500k~1M | 5 |
| 高速脉冲输入端子 | P07.75 | &gt;1M | 3 |

举例：设定值为30，则实际脉冲输入管脚滤波时间为30\*25=750ns。

**脉冲指令形态**

伺服驱动器可输入的脉冲指令有以下3种形态：

- 方向+脉冲(正逻辑或者负逻辑)
- AB正交，4倍频
- 正向脉冲 / 负向脉冲(CW+CCW)

请根据上位机或者其他脉冲输出装置，设定脉冲形态。

| **功能码** | **名称** | **设定范围** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|
| P13 | 14 | 脉冲指令形态 | 0:方向+脉冲(正逻辑)   1:方向+脉冲(负逻辑)   2:A相+B相正交脉冲4倍频   3:CW+CCW | 选择脉冲指令形态 | 停机设定 | 再次通电 | 0 |