### 转矩指令来源

转矩控制模式具有以下五种转矩指令获取方式，通过功能码P15.00设定。

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/686602d5592b5.png)

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P15 | 00 | 转矩指令来源选择 | 0：来源A   1：来源B   2：来源A+B   3：来源A\\B DI切换   4：通讯给定 | - | 选择转矩指令来源 | 停机设定 | 立即生效 | 0 |

---

### 转矩指令来源A

转矩指令来源A包括键盘给定、模拟量电压给定两种指令形式。其中键盘给定为内部转矩指令，模拟量电压给定为外部转矩指令。

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/68660340394d2.png)

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P15 | 01 | 转矩指令来源A | 0：键盘给定(P15.13)   1：AI1给定   2：AI2给定 | - | 选择转矩指令来源A | 停机设定 | 立即生效 | 0 |

#### 键盘给定

指通过功能码P15.13设定，指令转矩相对于电机额定转矩的百分比。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P15 | 13 | 转矩指令键盘设定 | -300.0~300.0 | % | 对内部转矩指令进行数值设置其精度为0.1%。 | 运行设定 | 立即生效 | 0 |

#### 模拟量电压给定

指将上位机或者其他设备输出的模拟量电压信号，经过处理后作为转矩指令。

模拟量电压输入端子

伺服驱动器具有2路模拟输入通道：AI1与AI2，最大输入电压为±10Vdc，输入阻抗约：9kΩ。

模拟量输入电路：

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/686603e19253f.png)

操作方法：

以AI1为例说明模拟量电压设定转矩指令方法。

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/68660401dfea5.png)

零漂：指模拟通道输入电压为零时，伺服驱动器采样电压值相对于GND的数值。

偏置：指零漂校正后，采样电压为零时对应模拟通道输入电压值。

死区：指使采样电压为零时，对应模拟通道输入电压区间。

未经处理的模拟通道输出电压如图y1所示，经伺服驱动器内部处理后，最终得到转矩指令y6。

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/6866042a75456.png)

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/6866043896ddb.png)

滤波

- 伺服驱动器提供模拟通道滤波功能，通过设置滤波时间常数P03.44，可防止由于模拟输入电压不稳定导致的电机指令波动，也可减弱由干扰信号引起的电机错误动作。滤波功能对零漂与死区无消除或抑制作用。

零漂校正：

- 校正实际输入电压为0V时，模拟通道输出电压偏离0V的数值。
- 未经驱动器内部处理的模拟通道输出电压如y1所示。以滤波时间常数P03.44 = 0.00ms为例，滤波后采样电压y2与y1一致。
- 可见，实际输入电压x=0时，输出电压y1=400.0mV，此400.0mV即称为零漂。
- 手动设置P03.47=400.0(mV)，经零漂校正后，采样电压如y3所示。y3=y1-400.0
- 零漂也可以通过模拟通道自动调整功能(P20.15)自动校正。

偏置设置：

- 设定采样电压为0时对应的实际输入电压值。
- 预设定采样电压y3=0时，对应的实际输入电压x=4000mV，此4000mV即称为偏置。
- 手动设置P02.48=4000(mV)，经偏置后，采样电压如y4所示。y4=y3+4000

死区校正：

- 限定驱动器采样电压不为0时，有效的输入电压范围。
- 偏置设置完成后，输入电压x在3200mv和4800mv以内时，采样电压值均为0，此800.0mV即称为死区。
- 置P03.46=800，经死区校正后，采样电压如y5所示。![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/6866050f0d286.png)

计算转矩指令：

- 零漂、偏置、死区设定完成后，需通过P03.63设定此时的采样电压中，10V(10000mV)对应的转矩指令值，实际转矩指令y6：![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/6866052273eda.png)

该值将作为转矩控制模式模拟量转矩指令给定值。

其中，无偏置时如图所示，有偏置如图所示。当完成正确设置后，可通过P09.22实时查看AI1采样电压值，也可通过P09.22查看输入的模拟量转矩指令值。

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/6866053610dc9.png)

最终转矩指令值 y6 与输入电压 x 的关系：

![](https://resource.helplook.net/docker_production/3648ne/article/bRTVkbCS/68660556aa166.png)

 

其中：B：偏置；C：死区。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P02 | 48 | AI1偏移量电压 | -10000 ~ 10000 | mV | 设定AI1通道模拟量偏置值 | 运行设定 | 立即生效 | 0 |
| P03 | 44 | AI1输入滤波时间 | 0~655.35 | ms | 设定AI1通道模拟量平均值滤波时间常数 | 运行设定 | 立即生效 | 2.00 |
| P03 | 46 | AI1死区 | 0~1000.0 | mV | 设定AI1通道模拟量死区值 | 运行设定 | 立即生效 | 10.0 |
| P03 | 47 | AI1零漂 | -500.0~500.0 | mV | 设定AI1通道模拟量零漂值 | 运行设定 | 立即生效 | 0.0 |
| P03 | 63 | 模拟量10V对应转矩 | 1.00倍~8.00倍额定转矩 | 倍 | 设定模拟量10V对应转矩值 | 停机设定 | 立即生效 | 1.00 |
| P20 | 15 | AI零点偏移校正 | 0：无操作1：AI1调整2：AI2调整 | - | 模拟量AI1、AI2通道零漂自动校正使能 | 停机设定 | 立即生效 | 0 |

注释:当选择使用模拟量AI2输入通道时，其设置方法和上述模拟量AI1设置方法类似

 

---

### 转矩指令来源B

转矩指令来源B使用方法，同主转矩指令A来源。

---

### A/B切换来源

当转矩指令选择“A/B切换”即功能码P15.00=3时，需要将DI功能FunIN.23分配到相应的DI端子上，根据此DI端子上的输入信号决定当前A指令源输入有效或B指令源输入有效。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunIN.23 | 运行指令切换 | OFF：当前运行指令为A   ON：当前运行指令为B |  |

---

### 通讯给定

指当功能码P15.00设置为4时，转矩指令来源于功能码P20.54设定值，且功能码P20.54必须通过通讯方式修改，控制面板不可见。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P20 | 54 | 总线给定转矩指令 | -100.000~100.000 | % | 对通讯给定形式的转矩指令值进行设置；其精度为0.001%。 | 运行设定 | 立即生效 | - |

---

### 转矩指令方向设置

通过DI 端子实现转矩指令方向切换，即将DI功能FunIN.19分配到相应的DI端子上，根据此DI端子上的输入信号决定当前的转矩指令方向，从而满足转矩指令方向切换的需求。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunIN.19 | 转矩指令方向切换 | 无效-实际转矩指令方向与设定方向相同   有效-实际转矩指令方向与设定方向相反 |  |

实际电机运动方向与运动方向选择(P04.01)、转矩指令方向、转矩指令方向DI切换(FunIN.19)三者有关。

| **P04.01** | **转矩指令正负** | **FunIN.19** | **实际电机运动方向** |
|---|---|---|---|
| 0 | + | 无效 | 逆时针 |
| 0 | + | 有效 | 顺时针 |
| 0 | - | 无效 | 顺时针 |
| 0 | - | 有效 | 逆时针 |
| 1 | + | 无效 | 顺时针 |
| 1 | + | 有效 | 逆时针 |
| 1 | - | 无效 | 逆时针 |
| 1 | - | 有效 | 顺时针 |