### 转矩指令限制

转矩指令限制在位置控制、速度控制、转矩控制及混合控制模式下均有效，且必须对其进行设置！

为保护驱动器和电机，应对转矩指令进行限制。

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661b9dd5ff3.png)

当上位机输入或速度调节器输出的转矩指令的绝对值，大于转矩指令限制的绝对值时，则实际驱动器的转矩指令被限幅等于转矩指令限制值；反之，则等于上位机输入或速度调节器输出的转矩指令值。任一时刻，有且只有一个转矩限制值有效。且正负转矩限制值均不超过驱动器和电机的最大转矩以及±300.0%额定转矩。

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661bbd32a56.png)

---

### 设定转矩限制来源

转矩限制来源可由功能码P15.03设定。设定转矩限制后，驱动器转矩指令将被限制在转矩限制值以内，当达到转矩限制值后，则电机将以转矩限制值为转矩指令运行。转矩限制值应根据负载运行要求设定。设定过小，可能导致电机加减速能力减弱，恒转矩运行时，电机实际转速值达不到需求值。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P15 | 03 | 转矩限制来源选择 | 0：内部转矩限制值1   1：外部AI限制   2：DI切换内部转矩限制值1和限制值2   3：DI切换内部转矩限制值1和外部AI限制   4：内部转矩限制值1和外部AI限制最小值 | - | 选择转矩限制来源 | 停机设定 | 立即生效 | 0 |

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661c3fb753f.png)

以下图示，均为转矩模式下，上位机输入的转矩指令绝对值大于转矩限制值绝对值的情况。

#### P15.03 = 0：内部转矩限制值

转矩指令限制值仅由内部功能码P15.05和P15.06决定。

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661c82b88e9.png)

#### P15.03 = 1：外部AI限制

根据P15.04选择外部模拟通道后，转矩指令限制值由AI端子输入电压对应的转矩值决定。

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661cb891b90.png)

P15.03=1转矩限制曲线图

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661cc4cd1fe.png)

#### P15.03 = 2：DI切换内部转矩限制值1和限制值2

转矩指令限制值根据外部DI信号的逻辑状态选择。正转矩限制值在功能码P15.05和P15.07之间选择；负转矩限制值在功能码P15.06和P15.08之间选择。

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661cf88a085.png)

| **DI功能状态** | **FunIN.14正向转矩限制选择** |
|---|---|
| **OFF** | **ON** |
| FunIN.15反向转矩限制选择 | OFF | 正转矩限制值由P15.05设定   负转矩限制值由P15.06设定 | 正转矩限制值由P15.07设定   负转矩限制值由P15.06设定 |
| ON | 正转矩限制值由P15.05设定   负转矩限制值由P15.08设定 | 正转矩限制值由P15.07设定   负转矩限制值由P15.08设定 |

此时，分配驱动器的2个DI端子分别为DI功能FunIN.14 (正向转矩限制选择) 与FunIN.15 (反向转矩限制选择)，并确定DI端子逻辑。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunOUT.14 | 正向转矩限制选择 | 根据P15.03的选择，进行转矩限制源的切换。   P15.03=2时：   有效-正转外部转矩限制有效；无效-正转内部转矩限制有效。   P15.03=3且AI限制值大于正转外部限制值时：   有效-正转外部转矩限制有效；无效-AI转矩限制有效。   P15.03=4时：   有效-AI转矩限制有效；无效-正转内部转矩限制有效。 |  |
| FunIN.15 | 反向转矩限制选择 | 根据P15.03的选择，进行转矩限制源的切换。   P15.03=2时：   有效-反转外部转矩限制有效；无效-反转内部转矩限制有效。   P15.03=3且AI限制值小于反转外部限制值时：   有效-反转外部转矩限制有效。无效-AI转矩限制有效。   P15.03=4时：   有效-AI转矩限制有效；无效-反转内部转矩限制有效。 |  |

####  

#### P15.03 = 3：DI切换内部转矩限制值1和外部AI限制

正转矩限制：根据P15.04选择外部模拟通道后，  
外部DI信号(FunIN.14)逻辑无效时，正转矩限制值由功能码P15.05决定；  
外部DI信号(FunIN.14)逻辑有效时，正转矩限制值由AI端子输入电压对应的转矩值决定。  
负转矩限制：根据P15.04选择外部模拟通道后，  
外部DI信号FunIN.15)逻辑无效时，负转矩限制值由功能码P15.06决定；  
外部DI信号(FunIN.15)逻辑有效时，负转矩限制值由AI端子输入电压对应的转矩值决定。

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/68661e70c5c0f.png)

| **DI功能状态** | **FunIN.14正向转矩限制选择** |
|---|---|
| **OFF** | **ON** |
| FunIN.15反向转矩限制选择 | OFF | 正转矩限制值由P15.05设定   负转矩限制值由P15.06设定 | 正转矩限制值由AI输入对应的转矩值设定   负转矩限制值由P15.06设定 |
| ON | 正转矩限制值由P15.05设定负转矩限制值由AI输入对应的转矩值设定 | 正转矩限制值由AI输入对应的转矩值设定负转矩限制值由AI输入对应的转矩值设定 |

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P15 | 04 | 转矩限制AI选择 | 1：AI1限制   2：AI2限制 | - | 选择转矩限制信号的模拟量输入通道 | 停机设定 | 立即生效 | 1 |
| P15 | 05 | 正转内部转矩限制值1 | 0~300.0 | % | 设定内部正负转矩限制值(100%对应1倍额定转矩) | 运行设定 | 立即生效 | 300.0 |
| P15 | 06 | 反转内部转矩限制值1 | 0~300.0 | % | 运行设定 | 立即生效 | 300.0 |
| P15 | 07 | 正转内部转矩限制值2 | 0~300.0 | % | 设定外部正负转矩限制值(100%对应1倍额定转矩) | 运行设定 | 立即生效 | 300.0 |
| P15 | 08 | 反转内部转矩限制值2 | 0~300.0 | % | 运行设定 | 立即生效 | 300.0 |

#### P15.03 = 4：内部转矩限制值1和外部AI限制最小值

正转矩限制：根据P15.04选择外部模拟通道后，  
外部DI信号(FunIN.14)逻辑无效时，正转矩限制值由外部AI端子输入电压对应的转矩值决定；  
外部DI信号(FunIN.14)逻辑有效时，正转矩限制值由功能码P15.07和AI端子输入电压对应的转矩值中的较小值决定。  
负转矩限制：根据P15.08选择外部模拟通道后，  
外部DI信号(FunIN.15)逻辑无效时，负转矩限制值由外部AI端子输入电压对应的转矩值决定；  
外部DI信号(FunIN.15)逻辑有效时，负转矩限制值由功能码P15.08和AI端子输入电压对应的转矩值中的较小值决定。

![](https://resource.helplook.net/docker_production/3648ne/article/RYZDeyjB/6866223394763.png)

**P15.03=4说明**

| **DI功能状态** | **FunIN.14正向转矩限制选择** |
|---|---|
| **OFF** | **ON** |
| FunIN.15反向转矩限制选择 | OFF | 正转矩限制值由AI输入对应的转矩值设定负转矩限制值由AI输入对应的转矩值设定。 | 正转矩限制值由AI输入对应的转矩值与P15.07比较，取最小值设定；   负转矩限制值由AI输入对应的转矩值设定。 |
| ON | 正转矩限制值由AI输入对应的转矩值设定负转矩限制值由AI输入对应的转矩值与P15.08比较，取最小值设定。 | 正转矩限制值由AI输入对应的转矩值与P15.07比较，取最小值设定；   负转矩限制值由AI输入对应的转矩值与P15.08比较，取最小值设定。 |

---

### 设定转矩限制DO输出信号

转矩指令达到转矩限制值时，驱动器输出转矩限制信号(FunOUT.12：转矩限制)，供上位机使用，此时应分配驱动器的1个DO端子为DO功能FunOUT.12，并确定DO端子逻辑。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunOUT.12 | 转矩限制 | 有效-驱动器转矩指令达到转矩限制值，并被限制为限制值无效-驱动器转矩指令未达到限定值 |  |