### 速度指令来源

速度控制模式具有以下五种速度指令获取方式，通过功能码P14.00设定。

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f228e6754.png)

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P14 | 00 | 速度指令来源选择 | 0：来源A   1：来源B   2：来源A+B   3：来源A\\B DI切换   4：通信给定 | - | 设定速度指令来源选择 | 停机设定 | 立即生效 | 0 |

---

### 速度指令来源A

速度指令来源A包括键盘给定、模拟量电压给定、预设速度任务指令三种指令形式。其中键盘给定、预设速度任务指令为内部速度指令，模拟量电压给定为外部速度指令。

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f2b21fa48.png)

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P14 | 01 | 速度指令来源A | 0：键盘给定   1：预设速度给定   2：AI1给定   3：AI2给定 | - | 设定速度指令来源A | 停机设定 | 立即生效 | 0 |

#### 键盘给定

指通过功能码P14.07设定速度值，并作为速度指令。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P14 | 07 | 速度指令键盘设定值 | -9999~30000 | rpm | 设定速度指令键盘设定值 | 运行设定 | 立即生效 | 60 |

#### 模拟量电压给定

- 指将上位机或者其他设备输出的模拟量电压信号，经过处理后作为速度指令。
- 模拟量电压输入端子： 
    - 伺服驱动器具有2路模拟输入通道：AI1与AI2，最大输入电压为±10Vdc，输入阻抗约：9kΩ。
- 模拟量输入电路：

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f3604a412.png)

操作方法：

以AI2为例说明模拟量电压设定速度指令方法

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f3801b59e.png)

零漂：指模拟通道输入电压为零时，伺服驱动器采样电压值相对于GND的数值。

偏置：指零漂校正后，采样电压为零时对应模拟通道输入电压值。

死区：指使采样电压为零时，对应模拟通道输入电压区间。

未经处理的模拟通道输出电压如图，y1所示，经伺服驱动器内部处理后，最终得到速度指令y6。

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f3d2e51cc.png)

伺服驱动器 AI 处理对应采样电压举例

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f3e1bda23.png)

滤波：

- 伺服驱动器提供模拟通道滤波功能，通过设置滤波时间常数P03.48，可防止由于模拟输入电压不稳定导致的电机指令波动，也可减弱由干扰信号引起的电机错误动作。滤波功能对零漂与死区无消除或抑制作用。

零漂校正：

- 校正实际输入电压为0V时，模拟通道输出电压偏离0V的数值。
- 图中，未经驱动器内部处理的模拟通道输出电压如y1所示。以滤波时间常数P03.48 = 0.00ms为例，滤波后采样电压y2与y1一致。
- 可见，实际输入电压x=0时，输出电压y1=400.0mV，此400.0mV即称为零漂。
- 手动设置P03.48=400.0(mV)，经零漂校正后，采样电压如y3所示。y3=y1-400.0
- 零漂也可以通过模拟通道自动调整功能(P20.15)自动校正。

偏置设置：

- 设定采样电压为0时，对应的实际输入电压值。
- 如图，预设定采样电压y4=0时，对应的实际输入电压x=4000mV，此4000mV即称为偏置。

手动设置P02.49=4000(mV)，经偏置后，采样电压y4=x-4000 = y3-4000

死区校正：

- 限定驱动器采样电压不为0时，有效的输入电压范围。
- 偏置设置完成后，输入电压x在3200mV和4800mV以内时，采样电压值均为0，此800.0mV即称为死区。
- 设置P03.50=800.0，经死区校正后，采样电压如y5所示。

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f47f806dc.png)

计算速度指令：

- 零漂、偏置、死区设定完成后，需通过 P03.62 设定此时的采样电压中，10V(10000mV)对应的速度指令值，实际速度   
    指令 y6：

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f4a4ea26b.png)

该值将作为速度控制模式模拟量速度指令给定值。

其中，无偏置时如图所示，有偏置如图所示。当完成正确设置后，可通过P09.23实时查看AI2采样电压值，也可通过P09.01查看输入的模拟量对应的速度指令值。

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f4dc8d64f.png)

最终速度指令值y6与输入电压x的关系：

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f4ff9a3fe.png)

其中：B：偏置；C：死区。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P02 | 49 | AI2偏移电压 | -10000~10000 | mV | 设定AI2通道模拟量偏置值 | 运行设定 | 立即生效 | 0 |
| P03 | 48 | AI2输入滤波时间 | 0~655.35 | ms | 设定AI2通道模拟量平均值滤波时间常数 | 运行设定 | 立即生效 | 2.00 |
| P03 | 50 | AI2死区 | 0~1000.0 | mV | 设定AI2通道模拟量死区值 | 运行设定 | 立即生效 | 10.0 |
| P03 | 51 | AI2零漂 | -500.0~500.0 | mV | 设定AI2通道模拟量零漂值 | 运行设定 | 立即生效 | 0.0 |
| P03 | 62 | 模拟量10V对应速度值 | 0~6000 | rpm | 设定模拟量10V对应速度值 | 停机设定 | 立即生效 | 3000 |
| P20 | 15 | AI零点漂移校正 | 0:无操作1:AI1调整2:AI2调整 | - | 模拟量AI1、AI2通道零漂自动校正使能 | 停机设定 | 立即生效 | 0 |

注释：当选择使用模拟量AI1输入通道时，其设置方法和上述模拟量AI2设置方法类似。

---

### 速度指令来源B

速度指令来源B包括键盘给定、模拟量电压给定、预设速度任务三种指令形式。其中键盘给定、预设速度任务指令为内部速度指令，模拟量电压给定为外部速度指令。

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f58a419b1.png)

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P14 | 02 | 速度指令来源B | 0:键盘给定1:预设速度给定2:AI1给定3:AI2给定 | - | 设定速度指令来源B | 停机设定 | 立即生效 | 1 |

其中，数字给定与模拟量电压设置方法同速度指令来源A。

以下主要介绍预设速度任务指令。伺服驱动器具有预设速度任务运行功能。它是指伺服驱动器内部存储了16段速度指令，每段的最大运行速度、运行时间可分别设置。并配有4组加减速时间可供选择。其设定流程如下：

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f5d587f9b.png)

#### 设定预设速度任务运行模式

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P16 | 00 | 预设速度指令运行方式 | 0：单次运行1：循环运行2：DI切换运行 | - | 设定预设速度指令运行方式 | 停机设定 | 立即生效 | 1 |
| P16 | 01 | 速度指令终点段数选择 | 1~16 | - | 设定速度指令终点段数选择 | 停机设定 | 立即生效 | 16 |
| P16 | 02 | 运行时间单位选择 | 0：S1：min | - | 设定运行时间单位选择 | 停机设定 | 立即生效 | 0 |

可配置外部DI端子，并置为功能FunIN.20：速度指令方向切换，用于预设位置指令方向选择。

| **功能编号** | **功能名称** | **描述** |
|---|---|---|
| FunIN.20 | 速度指令方向选择 | 无效-正方向；有效-反方向。 |

以P16.01=2为例说明各模式。

单次运行结束停机(P16.00=0)

功能码P16.00设定为0，选择单次运行停机方式。根据执行总段数和执行时间单位分别设定功能码P16.01、P16.02后，并根据需求设置相应段的指令值，运行时间和加减速时间等参数，驱动器将按照段码从第1段到第N段的方式运行，直到运行完最后一段后停机。

**单次运行结束停机说明**

| **模式描述** | **运行曲线** |
|---|---|
| 运行1轮；段号自动递增切换； | ![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f6e3c07c2.png)  V1max、V2max：第1段、第2段指令速度；   t1：第1段实际加减速时间；   t3、t5：第2段时间加、减速时间；   某段运行时间：上一段速度指令切换到该段速度指令的变速时间+该段匀速运行时间(如：图中第一段运行时间为t1+t2，第二段运行时间为t3+t4，以此类推)某段运行时间勿设为0，驱动器将跳过该段速度指令，执行下一段；   电机实际转速达到该段设定的最大运行速度，速度到达信号有效；   某段运行时发生伺服使能OFF，电机按照伺服OFF停机方式停机(H02-05)。 |

注释：驱动器完整地运行1次P16.01设定的预设速度任务指令总段数称为完成1轮运行。

循环运行(P16.00=1)

功能码P16.00设定为1，选择循环运行方式。根据执行总段数和执行时间单位分别设定功能码P16.01、 P16.02后，并根据需求设置相应段的指令值，运行时间和加减速时间等参数，模块将根据各段指令运行时间和加减速时间的设置，驱动器将按照段码从第1段到第N段的方式运行，运行完最后一段后自动跳转到第1段循环运行。

| **模式描述** | **运行曲线** |
|---|---|
| 循环运行，每轮起始段号均为1；   段号自动递增切换；   伺服使能有效，则一直保持循环运行状态。 | ![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f74d1fbd6.png)   V1max、V2max：第1段、第2段最大运行速度；   某段运行时间：上一段速度指令切换到该段速度指令的变速时间+该段匀速运行时间(比如：图中第一段运行时间为t1+t2，第二段运行时间为t3+t4，以此类推)某段运行时间勿设为0，驱动器将跳过该段速度指令，执行下一段；   电机实际转速达到该段设定的最大运行速度，速度到达信号有效；   某段运行时发生伺服使能OFF，电机按照伺服OFF停机方式停机(P04.12)。 |

DI切换运行(P16.00=2)

功能码P16.00设定为2，选择外部DI切换方式。根据执行总段数和执行时间单位分别设定功能码P16.01、 P16.02后，并根据需求设置相应段的指令值，运行时间和加减速时间等参数，驱动器将根据外部DI的ON/OFF组合来选择运行对应段号的速度指令。

| **模式描述** | **运行曲线** |
|---|---|
| 伺服使能有效即可持续运行；   段号由 DI 端子逻辑决定；   每段速度指令运行时间仅由段号切换间隔时间决定 | ![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f7ad91149.png)  x，y：段号，段号与DI端子逻辑关系如下文所述；   某段运行时间不受功能码设定值影响，某段速度指令运行期间，若段号发生变化，则立刻切换到新的段号运行；   电机实际转速达到该段设定的最大运行速度，速度到达信号有效；   某段运行时发生伺服使能OFF，电机按照伺服OFF停机方式停机(P04.12); |

多段位置运行方式设置为DI切换运行时，必须将伺服驱动器的4个DI端子配置为功能27~30(FunIN.27 ~ FunIN.30多段运行指令切换)，并确定DI端子有效逻辑。同时可将伺服驱动器的1个DI端子配置为功能20(FunIN.20 ：速度指令方向选择)，切换速度指令方向。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunIN.20 | 速度指令方向选择 | 无效-正方向；有效-反方向。 | 仅在预设速度指令DI切换模式下，用于设置速度指令方向： |
| FunIN.27 | 预设指令选择1 | 多段段号为4位二进制数，FunIN.27~FunIN.30与段号的对应关系如下表所示。 \| FunIN.30 \| FunIN.29 \| FunIN.28 \| FunIN.27 \| 段号 \| \| 0 \| 0 \| 0 \| 0 \| 1 \| \| 0 \| 0 \| 0 \| 1 \| 2 \| \| … \| \| 1 \| 1 \| 1 \| 1 \| 16 \|    DI端子输入电平有效时CMD值为1，否则为0 |  |
|---|---|
| FunIN.28 | 预设指令选择2 |  |
| FunIN.29 | 预设指令选择3 |  |
| FunIN.30 | 预设指令选择4 |  |

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f8300b473.png)

#### 预设速度任务运行曲线设定

以第1段速度指令为例，相关功能码如下：

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P16 | 03 | 加速时间1 | 0~65535 | ms | 设定第1组加减速时间 | 停机设定 | 立即生效 | 10 |
| P16 | 04 | 减速时间1 | 0~65535 | ms |  | 停机设定 | 立即生效 | 10 |
| P16 | 09 | 加速时间4 | 0~65535 | ms | 设定第4组加减速时间 | 停机设定 | 立即生效 | 150 |
| P16 | 10 | 减速时间4 | 0~65535 | ms |  | 停机设定 | 立即生效 | 150 |
| P16 | 20 | 第1段速度指令 | -6000~6000 | rpm | 设定第1段速度指令值 | 停机设定 | 立即生效 | 0 |
| P16 | 21 | 第1段指令运行时间 | 0~6553.5 | s(min) | 设定第1段指令运行时间 | 停机设定 | 立即生效 | 5.0 |
| P16 | 22 | 第1段加减速时间 | 0：零加减速时间   1：加减速时间1   2：加减速时间2   3：加减速时间3   4：加减速时间4 | - | 选择第1段加减速方式 | 停机设定 | 立即生效 | 0 |

预设速度任务指令参数中除1~16段指令值和指令运行时间外，有4组加减速时间可供选择，默认方式为没有加减速时间。以预设速度任务中P16.01=1单次运行结束为例，对实际加减速时间以及运行时间说明：

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f89dcf0c8.png)

如上图所示，该段速度指令为V1，实际加速时间t1为：

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f8e56e772.png)

实际减速时间t2：

![](https://resource.helplook.net/docker_production/3648ne/article/gO8zxY2L/6865f8ef16bda.png)

运行时间：上一段速度指令切换到该段速度指令的变速时间+该段匀速运行时间，如图中t3所示。

---

### A/B DI切换来源

当速度指令选择“A/B切换”即功能码P14.00=3时，需要将DI功能FunIN.23分配到相应的DI端子上，根据此DI端子上的输入信号决定当前A指令源输入有效或B指令源输入有效。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunIN.23 | 运行指令切换 | 无效：当前运行指令为A   有效：当前运行指令为B | - |

---

### 通讯给定

指当功能码P14.00设置为4时，速度指令值来源于功能码P20.52设定值，且功能码P20.52必须通过通讯方式修改，控制面板不可见。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P20 | 52 | 总线给定速度指令 | -9000.000~9000.000 | rpm | 对通讯给定形式的速度指令值进行设置；精度为0.001rpm | 运行设定 | 立即生效 | 0 |

---

### 速度指令方向设置

通过DI实现速度指令方向切换，即将DI功能FunIN.20分配到相应的DI端子上，根据此DI端子上的输入信号决定当前的速度指令方向，从而满足速度指令方向切换的需求。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunIN.20 | 速度指令方向选择 | 无效：正方向；   有效：反方向。 |  |

实际电机运行方向与运行方向选择(P04.01)、速度指令方向、速度指令方向DI切换(FunIN.20)三者有关。

**速度控制模式下电机实际运行方向设置**

| **P04.01** | **速度指令正负** | **FunIN.20** | **实际电机运行方向** |
|---|---|---|---|
| 0 | + | 无效 | 逆时针 |
| 0 | + | 有效 | 顺时针 |
| 0 | - | 无效 | 顺时针 |
| 0 | - | 有效 | 逆时针 |
| 1 | + | 无效 | 顺时针 |
| 1 | + | 有效 | 逆时针 |
| 1 | - | 无效 | 逆时针 |
| 1 | - | 有效 | 顺时针 |