### 功能介绍

- 回零功能指的是，给定动作速度，伺服驱动器根据外部信号进行机械原点定位的功能。
- 回零之后，电机实际位置反馈 = P13.51（原点机械偏移量）；
- 机械原点可以对应原点开关信号、正反限位开关、电机Z信号；
- 机械回零方式有多种，在实际使用时若无法断开电机与设备的机械连接，请查阅章节原点复归模式介绍选择合适的回零方式，避免损坏设备。
- 伺服处于回零模式，且正在运行时，不可切入其他模式；回零完成或被中断(故障或使能无效)时，可切入其他模式；
- 请注意限位开关与正反向限位开关之间的距离，不能太近，且须设置合适的加速度，否则可能导致撞机！

---

### 原点复归模式设置

| **功能码** | **名称** | **设定范围** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|
| P13 | 44 | 原点复归使能 | 0：关闭原点复归功能  1：通过DI使能原点复归功能  2：立即进行原点复归  3：以当前位置为原点 | 设置原点复归模式及触发信号来源 | 运行设定 | 立即生效 | 0 |
| P13 | 45 | 原点复归模式 | (-1)： 反向回零，减速点为机械极限位置，原点为电机Z信号，遇到Z信号前必须先遇到机械极限位置  (-2)： 正向回零，减速点为机械极限位置，原点为电机Z信号，遇到Z信号前必须先遇到机械极限位置  1: 反向回零，减速点为反向限位开关，原点为电机Z信号，遇到Z信号前必须先遇到反向限位下降沿  2: 正向回零，减速点为正向限位开关，原点为电机Z信号，遇到Z信号前必须先遇到正向限位下降沿  3: 正向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧下降沿  4: 正向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧上升沿  5: 反向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧下降沿  6: 反向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧上升沿  7: 正向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧下降沿  8: 正向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧上升沿  9: 正向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关另一侧上升沿  10: 正向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关另一侧下降沿  11: 反向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧下降沿  12: 反向回零，减速点为原点开关，原点为电机Z信号，遇到Z信号前必须先遇到原点开关同一侧上升沿  13: 反向回零，减速点为原点开关，原点为原点开关另一侧电机Z信号，遇到Z信号前必须先遇到原点开关另一侧上升沿  14: 正向回零，减速点为原点开关，原点为原点开关另一侧电机Z信号，遇到Z信号前必须先遇到原点开关另一侧下降沿  15~16: 保留  17~32: 与1~14相似，但减速点与原点重合  33: 反向回零，原点为电机Z信号  34:正向回零，原点为电机Z信号  35:以当前位置为原点 | 设置原点回零时回零方向、减速点、原点 | 停机设定 | 立即生效 | 1 |

---

### 原点复归运行曲线设置

若减速点信号有效后，在未充分减速情况下使得原点信号有效，则有可能导致最终定位不稳。应充分考虑减速所需的位移，再设置减速点和原点信号输入位置。搜索原点时的加减速度(P13.48)也会对定位稳定度造成影响，因此设置时应予以考虑。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P13 | 46 | 原点高速搜索速度 | 0~3000 | rpm | 设定原点回零时，搜索减速点信号的高速速度值。 | 停机设定 | 立即生效 | 60 |
| P13 | 47 | 原点低速搜索速度 | 0~1000 | rpm | 设定原点回零时，搜索原点时的低速速度值。速度设定值应低到防止停机时造成机械冲击。 | 停机设定 | 立即生效 | 10 |
| P13 | 48 | 原点回归加减速度 | 0~1000 | rpm/s | 设定原点复归时电机从0匀变速到1000rpm的加速度。 | 停机设定 | 立即生效 | 1000 |
| P13 | 49 | 原点查找时间 | 0~655.35 | s | 限定原点复归总时间，超时则发生警告A.425.0(原点回零失败)。 | 停机设定 | 立即生效 | 500.00 |
| P13 | 51 | 原点机械偏移量 | -1073741824~1073741824 | 指令单位 | 设置原点复归后电机绝对位置(P09.49)数值。 | 停机设定 | 立即生效 | 0 |

| **编码** | **功能名** | **功能** |
|---|---|---|
| FunIN.11 | 原点开关 | 有效，当前位置为原点； \| HomeSwitch设置的DI端子逻辑 \| 实际有效电平 \| \| 0(低电平) \| 低电平 \| \| 1(高电平) \| 高电平 \|  应根据上位机输出，将原点开关对应的DI端子逻辑设置为高/低电平有效。 |
|---|
| FunIN.12 | 回零使能 | 有效，使能原点复归功能，原点复归运行过程中，反复使能无效；无效，禁止原点复归功能。 |
| FunOut.14 | 回零完成 | 有效，位置控制时，原点回零完成。无效，原点回零未完成。 |

---

### 回零复位使能设置

**P13.44=0**

- - 关闭原点复归功能

**P13.44=1**

![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6864f457ec05d.png)

- 必须先打开伺服使能信号，再打开回零使能信号；
- 原点复归正在进行期间，伺服使能信号保持有效，HomingStart信号变化被屏蔽；
- 原点复归正在进行期间，伺服使能信号置为无效，伺服电机停止转动，重新启动原点复归，请先打开伺服使能信号，再打开HomingStart信号；
- 发生原点回零失败(A.425.0)，伺服电机停止转动，保持伺服使能信号有效，重新触发HomingStart信号有效，即可复位A.425.0，并重新执行原点复归；
- 可反复触发原点复归；

**P13.44=2**

上电后将伺服使能信号置为有效，立即进行原点复归；  
原点复归正在进行期间，伺服使能信号置为无效，伺服电机停止转动，重新将伺服使能信号置为有效，可重新触发原点复归；  
发生原点回零失败(A.425.0)，P13.44被置为0，伺服电机停止转动，将伺服使能信号置为无效可复位A.425.0；原点复归完成后，P13.44=0；若要重新进行原点复归，必须重新设定P13.44；

---

### 原点复归模式介绍

原点复归模式1

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6864f5707b7da.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 负向限位开关 \| |
|---|
| 方式1 | 动作描述 |
|  | 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 1.1-回零时减速点无效 \| 开始回零时，反向高速运行，遇到反向限位信号上升沿后，正向低速运行,遇到反向限位信号下降沿后的第一个Z相信号停机 \| \| 1.2-回零时减速点有效 \| 开始回零时直接开始正向低速回零，遇到反向限位信号下降沿后的第一个Z相信号停机 \| |
|---|

原点复归模式2

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6864f5e8e88bb.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 正向限位开关 \| |
|---|
| 方式2 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 2.1-回零时减速点无效 \| 开始回零时，正向高速运行，遇到正向限位信号上升沿后，反向低速运行,遇到正向限位信号下降沿后的第一个Z相信号停机 \| \| 2.2-回零时减速点有效 \| 开始回零时直接开始反向低速回零，遇到正向限位信号下降沿后的第一个Z相信号停机 \| |
|---|

原点复归模式3-4

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6864f614e58e6.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 原点开关信号 \| |
|---|
| 方式3 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 3.1-回零时减速点无效 \| 开始回零时，正向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后的第一个Z相信号停机 \| \| 3.2-回零时减速点有效 \| 开始回零时直接开始反向低速回零，遇到原点开关信号下降沿后的第一个Z相信号停机 \| |
|---|
| 方式4 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 4.1-回零时减速点无效 \| 开始回零时直接开始正向低速回零，遇到原点开关信号上升沿后的第一个Z相信号停机 \| \| 4.2-回零时减速点有效 \| 开始回零时，反向高速运行，遇到原点开关信号下降沿后，正向低速运行,遇到原点开关信号上升沿后的第一个Z相信号停机 \| |
|---|

原点复归模式5-6

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6864f65478eb1.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 原点开关信号 \| |
|---|
| 方式5 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 5.1-回零时减速点有效 \| 开始回零时直接开始正向低速回零，遇到原点开关信号下降沿后的第一个Z相信号停机 \| \| 5.2-回零时减速点无效 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后的第一个Z相信号停机 \| |
|---|
| 方式6 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 6.1-回零时减速点有效 \| 开始回零时，正向高速运行，遇到原点开关信号下降沿后，反向低速运行,遇到原点开关信号上升沿后的第一个Z相信号停机 \| \| 6.2-回零时减速点无效 \| 开始回零时直接开始反向低速回零，遇到原点开关信号上升沿后的第一个Z相信号停机 \| |
|---|

原点复归模式7-10

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6864f6796dc65.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 原点开关信号 \| |
|---|
| 方式7 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 7.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行；遇到原点开关信号上升沿后，反向低速运行；遇到原点开关信号下降沿后的第一个Z相信号停机。 \| \| 7.2-回零时减速点有效 \| 开始回零时，直接开始反向低速回零；遇到原点开关信号下降沿后的第一个Z相信号停机。 \| \| 7.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行；遇到原点开关之前遇到正向限位信号，反向高速运行；遇到原点开关信号上升沿后，继续反向低速运行；遇到原点开关信号下降沿后的第一个Z相信号停机。 \| |
|---|
| 方式8 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 8.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行；遇到原点开关信号上升沿后，反向低速运行；遇到原点开关信号下降沿后，正向低速运行；遇到原点开关信号上升沿后的第一个Z相信号停机。 \| \| 8.2-回零时减速点有效 \| 开始回零时，反向低速运行；遇到原点开关信号下降沿后，正向低速运行；遇到原点开关信号上升沿后的第一个Z相信号停机。 \| \| 8.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行；遇到原点开关之前遇到正向限位信号，反向高速运行；遇到原点开关信号上升沿后，反向低速运行；遇到原点开关信号下降沿后, 正向低速运行；遇到原点开关信号上升沿后的第一个Z相信号停机。 \| |
|---|
| 方式9 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 9.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行；遇到原点开关信号上升沿后，正向低速运行；遇到原点开关信号下降沿后，反向低速运行；遇到原点开关信号上升沿后的第一个Z相信号停机。 \| \| 9.2-回零时减速点有效 \| 开始回零时，正向低速运行，遇到原点开关信号下降沿后，反向低速运行，遇到原点开关信号上升沿后的第一个Z相信号停机。 \| \| 9.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关之前遇到正向限位信号，反向高速运行；遇到原点开关信号上升沿后，正向低速运行；遇到原点开关信号下降沿后, 反向低速运行；遇到原点开关信号上升沿后的第一个Z相信号停机。 \| |
|---|
| 方式10 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 10.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行；遇到原点开关信号上升沿后，正向低速运行；遇到原点开关信号下降沿后，继续正向低速运行；遇到原点开关信号下降沿后的第一个Z相信号停机。 \| \| 10.2-回零时减速点有效 \| 开始回零时，正向低速运行；遇到原点开关信号下降沿后，继续正向低速运行；遇到原点开关信号下降沿后的第一个Z相信号停机。 \| \| 10.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行；遇到原点开关之前遇到正向限位信号，反向高速运行；遇到原点开关信号上升沿后，正向低速运行；遇到原点开关信号下降沿后,继续正向低速运行；遇到原点开关信号下降沿后的第一个Z相信号停机。 \| |
|---|

原点复归模式11-14

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6864f6a8d3f00.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 原点开关信号 \| |
|---|
| 方式11 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 11.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后的第一个Z相信号停机 \| \| 11.2-回零时减速点有效 \| 开始回零时直接开始正向低速回零，遇到原点开关信号下降沿后的第一个Z相信号停机 \| \| 11.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后的第一个Z相信号停机 \| |
|---|
| 方式12 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 12.1-回零时减速点无效，且过程中未遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，正向低速运行，遇到原点开关信号下降沿后，反向低速运行，遇到原点开关信号上升沿后的第一个Z相信号停机 \| \| 12.2-回零时减速点有效 \| 开始回零时，正向低速运行，遇到原点开关信号下降沿后，反向低速运行，遇到原点开关信号上升沿后的第一个Z相信号停机 \| \| 12.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，正向低速运行，遇到原点开关信号下降沿后, 反向低速运行，遇到原点开关信号上升沿后的第一个Z相信号停机 \| |
|---|
| 方式13 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 13.1-回零时减速点无效，且过程中未遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，反向低速运行，遇到原点开关信号下降沿后，正向低速运行，遇到原点开关信号上升沿后的第一个Z相信号停机 \| \| 13.2-回零时减速点有效 \| 开始回零时，反向低速运行，遇到原点开关信号下降沿后，正向低速运行，遇到原点开关信号上升沿后的第一个Z相信号停机 \| \| 13.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后, 正向低速运行，遇到原点开关信号上升沿后的第一个Z相信号停机 \| |
|---|
| 方式14 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 14.1-回零时减速点无效，且过程中未遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，反向低速运行，遇到原点开关信号下降沿后，继续反向低速运行，遇到原点开关信号下降沿后的第一个Z相信号停机 \| \| 14.2-回零时减速点有效 \| 开始回零时，反向低速运行，遇到原点开关信号下降沿后，继续反向低速运行，遇到原点开关信号下降沿后的第一个Z相信号停机 \| \| 14.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后,继续反向低速运行，遇到原点开关信号下降沿后的第一个Z相信号停机 \| |
|---|

**方式15-16：保留；**

注意，方式17-30与1-14方式相似，区别就是不在依靠Z相信号作为原点，具体如下。

**原点复归模式17**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865ef5b87fd6.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| 负向限位开关 \| 负向限位开关 \| |
|---|
| 方式17 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 17.1-回零时减速点无效 \| 开始回零时，反向高速运行，遇到反向限位信号上升沿后，正向低速运行,遇到反向限位信号下降沿后停机 \| \| 17.2-回零时减速点有效 \| 开始回零时直接开始正向低速回零，遇到反向限位信号下降沿后停机 \| |
|---|

**原点复归模式18**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865ef7a6c39c.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| 正向限位开关 \| 正向限位开关 \| |
|---|
| 方式18 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 18.1-回零时减速点无效 \| 开始回零时，正向高速运行，遇到正向限位信号上升沿后，反向低速运行,遇到正向限位信号下降沿后停机 \| \| 18.2-回零时减速点有效 \| 开始回零时直接开始反向低速回零，遇到正向限位信号下降沿后停机 \| |
|---|

**原点复归模式19-20**

| 运动  框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865ef8f58d60.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| 原点开关信号 \| 原点开关信号 \| |
|---|
| 方式19 | 动作描述 |
| 注：不同的初始条件，动作不同  \| 初始条件 \| 回零动作 \| \| 19.1-回零时减速点无效 \| 开始回零时，正向高速运行，  遇到原点开关信号上升沿后，反向低速运行,  遇到原点开关信号下降沿后停机 \| \| 19.2-回零时减速点有效 \| 开始回零时直接开始反向低速回零，  遇到原点开关信号下降沿后停机 \| |
|---|
| 方式20 | 动作描述 |
| 注：不同的初始条件，动作不同  \| 初始条件 \| 回零动作 \| \| 20.1-回零时减速点无效 \| 开始回零时直接开始正向低速回零，  遇到原点开关信号上升沿后停机 \| \| 20.2-回零时减速点有效 \| 开始回零时，反向高速运行，  遇到原点开关信号下降沿后，正向低速运行,  遇到原点开关信号上升沿停机 \| |
|---|

**原点复归模式21-22**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865efafce876.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| 原点开关信号 \| 原点开关信号 \| |
|---|
| 方式21 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 21.1-回零时减速点有效 \| 开始回零时直接开始正向低速回零，遇到原点开关信号下降沿后停机 \| \| 21.2-回零时减速点无效 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后停机 \| |
|---|
| 方式22 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 22.1-回零时减速点有效 \| 开始回零时，正向高速运行，遇到原点开关信号下降沿后，反向低速运行,遇到原点开关信号上升沿后停机 \| \| 22.2-回零时减速点无效 \| 开始回零时直接开始反向低速回零，遇到原点开关信号上升沿停机 \| |
|---|

**原点复归模式23-26**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865effd3cfdd.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| 原点开关信号 \| 原点开关信号 \| |
|---|
| 方式23 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 23.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后停机 \| \| 23.2-回零时减速点有效 \| 开始回零时直接开始反向低速回零，遇到原点开关信号下降沿后停机 \| \| 23.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关之前遇到正向限位信号，反向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后停机 \| |
|---|
| 方式24 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 24.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关信号上升沿后，反向低速运行，遇到原点开关信号下降沿后，正向低速运行，遇到原点开关信号上升沿后停机 \| \| 24.2-回零时减速点有效 \| 开始回零时，反向低速运行，遇到原点开关信号下降沿后，正向低速运行，遇到原点开关信号上升沿后停机 \| \| 24.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关之前遇到正向限位信号，反向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后, 正向低速运行，遇到原点开关信号上升沿后停机 \| |
|---|
| 方式25 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 25.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关信号上升沿后，正向低速运行，遇到原点开关信号下降沿后，反向低速运行，遇到原点开关信号上升沿后停机 \| \| 25.2-回零时减速点有效 \| 开始回零时，正向低速运行，遇到原点开关信号下降沿后，反向低速运行，遇到原点开关信号上升沿后停机 \| \| 25.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关之前遇到正向限位信号，反向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后, 反向低速运行，遇到原点开关信号上升沿后停机 \| |
|---|
| 方式26 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 26.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关信号上升沿后，正向低速运行，遇到原点开关信号下降沿后，继续正向低速运行，遇到原点开关信号下降沿后停机 \| \| 26.2-回零时减速点有效 \| 开始回零时，正向低速运行，遇到原点开关信号下降沿后，继续正向低速运行，遇到原点开关信号下降沿后停机 \| \| 26.3-回零时减速点无效，且过程中遇到正向限位开关 \| 开始回零时，正向高速运行，遇到原点开关之前遇到正向限位信号，反向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后,继续正向低速运行，遇到原点开关信号下降沿后停机 \| |
|---|

**原点复归模式27-30**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865f02ebb475.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| 原点开关信号 \| 原点开关信号 \| |
|---|
| 方式27 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 27.1-回零时减速点无效，且过程中未遇到正向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后停机 \| \| 27.2-回零时减速点有效 \| 开始回零时直接开始正向低速回零，遇到原点开关信号下降沿后停机 \| \| 27.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，正向低速运行,遇到原点开关信号下降沿后停机 \| |
|---|
| 方式28 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 28.1-回零时减速点无效，且过程中未遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，正向低速运行，遇到原点开关信号下降沿后，反向低速运行，遇到原点开关信号上升沿后停机 \| \| 28.2-回零时减速点有效 \| 开始回零时，正向低速运行，遇到原点开关信号下降沿后，反向低速运行，遇到原点开关信号上升沿后停机 \| \| 28.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，正向低速运行，遇到原点开关信号下降沿后, 反向低速运行，遇到原点开关信号上升沿后停机 \| |
|---|
| 方式29 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 29.1-回零时减速点无效，且过程中未遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，反向低速运行，遇到原点开关信号下降沿后，正向低速运行，遇到原点开关信号上升沿后停机 \| \| 29.2-回零时减速点有效 \| 开始回零时，反向低速运行，遇到原点开关信号下降沿后，正向低速运行，遇到原点开关信号上升沿后停机 \| \| 29.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后, 正向低速运行，遇到原点开关信号上升沿后停机 \| |
|---|
| 方式30 | 动作描述 |
| 注：不同的初始条件，动作不同 \| 初始条件 \| 回零动作 \| \| 30.1-回零时减速点无效，且过程中未遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关信号上升沿后，反向低速运行，遇到原点开关信号下降沿后，继续反向低速运行，遇到原点开关信号下降沿后停机 \| \| 30.2-回零时减速点有效 \| 开始回零时，反向低速运行，遇到原点开关信号下降沿后，继续反向低速运行，遇到原点开关信号下降沿后停机 \| \| 30.3-回零时减速点无效，且过程中遇到反向限位开关 \| 开始回零时，反向高速运行，遇到原点开关之前遇到反向限位信号，正向高速运行，遇到原点开关信号上升沿后，反向低速运行,遇到原点开关信号下降沿后,继续反向低速运行，遇到原点开关信号下降沿后停机 \| |
|---|

**方式31-32：保留**

**原点复归模式33-34**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865f07a32811.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 无 \| |
|---|
| 方式33 | 动作描述 |
| 33-反向低速运行，遇到第一个Z相信号停机 |
| 方式34 | 动作描述 |
| 34-正向低速运行，遇到第一个Z相信号停机 |

**原点复归模式35**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865f0a4e9894.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| 当前位置 \| 无 \| |
|---|
| 方式35 | 动作描述 |
| 35-以当前位置为原点 |

**原点复归模式 -1**

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865f0c4b21f6.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 机械极限位置 \| |
|---|
| 方式-1 | 动作描述 |
| -1 :电机首先反向高速运行，撞到机械极限位置后，如果转矩达到转矩限制值，速度在零速附近，且此状态如果保持一定时间，判断为轴到达机械极限位置，电机正向低速运行，之后遇到第一个Z相信号停机。 |

原点复归模式-2

| 运动框图 | ![](https://resource.helplook.net/docker_production/3648ne/article/RWoywv9e/6865f0ee9c267.png) |
|---|---|
| 定位信号 | \| 原点 \| 减速点 \| \| Z相信号 \| 机械极限位置 \| |
|---|
| 方式-2 | 动作描述 |
| -2 :电机首先正向高速运行，撞到机械极限位置后，如果转矩达到转矩限制值，速度在零速附近，且此状态如果保持一定时间，判断为到达机械极限位置，电机反向低速运行，之后遇到第一个Z相信号停机。 |