### 转矩模式下速度限制

转矩控制模式下，若给定转矩指令过大，大于机械侧负载转矩，则将导致电机持续加速，可能发生超速现象，损坏机械设备。因此，为保护机械，必须对电机的转速进行限制。

![](https://resource.helplook.net/docker_production/3648ne/article/y2FbsDYq/6866231c543a3.png)

---

### 设定速度限制来源

转矩模式下，速度限制来源的选择可由功能码设定。设定速度限制后，实际电机转速将被限制在速度限制值以内。达到速度限制值后，电机以速度限制值恒速运行。速度限制值应根据负载运行要求设定。

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P15 | 09 | 转矩模式下速度限制来源选择 | 0：内部速度限制1：DI选择速度限制2：外部AI速度限制 | - | 选择转矩模式下速度限制来源 | 立即生效 | 运行设定 | 0 |

![](https://resource.helplook.net/docker_production/3648ne/article/y2FbsDYq/6866237a132e0.png)

#### P15.09=0：内部速度限制

电机不同方向运动时，转速仅由内部功能码P15.11和P15.12决定。

![](https://resource.helplook.net/docker_production/3648ne/article/y2FbsDYq/686623a63de8f.png)

#### P15.09=1：DI选择速度限制

伺服驱动器根据实际的DI端子逻辑选择P15.11或P15.12作为正/反转速度限制值。  
此时，应分配伺服驱动器一个DI逻辑为DI功能FunIN.13 (速度限制选择) 并分配DI端子逻辑。

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunIN.13 | 速度限制选择 | 无效-P15.11作为内部正/反转速度限制值   有效-P15.12作为内部正/反转速度限制值 |  |

| **FunIN.13 速度限制选择** |
|---|
| **OFF** | **ON** |
| ![](https://resource.helplook.net/docker_production/3648ne/article/y2FbsDYq/686624356af01.png)FunIN.13无效时速度限制值由P15.12设定 | ![](https://resource.helplook.net/docker_production/3648ne/article/y2FbsDYq/6866242b5a170.png)FunIN.13有效时速度限制值由P15.11设定 |

| **功能码** | **名称** | **设定范围** | **单位** | **功能** | **设定方式** | **生效时间** | **出厂设定** |
|---|---|---|---|---|---|---|---|
| P15 | 10 | 速度限制AI选择 | 1：AI12：AI2 | - | 选择以AI作为速度限制来源时的模拟量通道 | 立即生效 | 运行设定 | 1 |
| P15 | 11 | 转矩控制时内部速度正向限制值 | 0~6000 | rpm | 设定转矩模式下正向速度限制值/设定转矩模式下速度限制值1 | 立即生效 | 运行设定 | 3000 |
| P15 | 12 | 转矩控制时内部速度负向限制值 | 0~6000 | rpm | 设定转矩模式下反向速度限制值/设定转矩模式下速度限制值2 | 立即生效 | 运行设定 | 3000 |

#### P15.09=2：外部AI速度限制

电机不同方向运动时，通过P15.10指定的外部模拟通道，输入转速限制对应的电压。当AI输入小于内部速度限制(P15.11/P15.12)时，AI限制有效；反之，当AI输入大于内部速度限制(P15.11/P15.12)时，内部速度限制有效。

![](https://resource.helplook.net/docker_production/3648ne/article/y2FbsDYq/686627c72bb61.png)

---

### 设定速度限制DO输出信号

转矩模式下，伺服电机实际转速绝对值超过速度限制值，且时间达到P15.24时，认为伺服电机实际转速受限，此时伺服驱动器可输出速度限制 (FunOUT.13：速度限制)信号，供上位机使用。反之，不满足任一条件，速度限制信号无效。

速度限制 (FunOUT.13：速度限制)信号的判断仅在转矩模式，伺服运行状态下进行。

应分配伺服驱动器的1个DO端子为DO功能FunOUT.13，并设置DO端子逻辑。

![](https://resource.helplook.net/docker_production/3648ne/article/y2FbsDYq/686628013d67a.png)

| **功能编号** | **功能名称** | **描述** | **备注** |
|---|---|---|---|
| FunOUT.13 | 速度限制选择 | 有效-电机转速受限；   无效-电机转速不受限 |  |