### 故障处理

| **故障字码及其描述** | **故障原因** | **处理措施** |
|---|---|---|
| E.010.0厂家参数校验异常 | 1.更新了软件。2.参数存储过程中瞬间掉电。3.一定时间内参数的写入次数超过了最大值。4.伺服驱动器故障。 | 1.恢复出厂参数(P0501=1)。2.重新上电，系统参数恢复初始化(P0501=1)后，重新写入参数。3.改变参数写入方法。4.更换伺服驱动器。 |
| E.011.0软件内部通讯初始化异常 | 1.FPGA和MCU软件版本不匹配。2.FPGA故障。 | 1.咨询我司技术支持，更新相互匹配的FPGA或者MCU软件。2.联系厂家技术支持。 |
| E.012.0软件版本与产品型号不匹配 | 1.FPGA版本过低。2.FPGA故障。 | 1.更新相互匹配的FPGA或者MCU软件。2.联系厂家技术支持。 |
| E.013.0FPGA中断信号丢失 | 1.FPGA故障。2.FPGA与MCU通信握手异常。3.驱动器内部运算超时。 | 1.更换伺服驱动器。2.联系厂家技术支持。 |
| E.014.0MCU与FPGA通讯超时 | 1.MCU通信超时。2.编码器通信超时。 | 1.使用我司标配的电机线缆和编码器线缆。2.检查线缆连接，是否损坏。3.强弱电线缆分开走。 |
| E.015.0电流芯片采样超时 | 1.检查动力线输出是否断线或接触不良。2.电流采样超时。 | 1.使用我司标配的电机线缆和编码器线缆。2.检查线缆连接，是否损坏。3.强弱电线缆分开走。 |
| E.016.0转矩指令更新超时 | 1.伺服驱动器故障。 | 1.更换伺服驱动器。2.联系厂家技术支持。 |
| E.017.0参数存储写入异常 | 1.EEPROM数据错误故障。 | 1.系统参数恢复初始化(P0501=1)后，重新上电。2.更换伺服驱动器。 |
| E.018.0厂家参数超出范围 | 1.更新了软件，功能码当前值超出了允许范围。2.EEPROM故障。3.伺服驱动器故障。 | 1.重新上电，系统参数恢复初始化(P0501=1)后，重新写入参数。2.更换伺服驱动器。 |
| E.019.0编码器匹配故障 | 1.产品编号（电机或驱动器）不存在。2.电机与驱动器功率等级不匹配。 | 1.参考“伺服系统配套规格”，更换不匹配的产品。 |
| E.210.0P、N相过流 | 1.制动电阻过小或短路。2.电机线缆接触不良或短路。3.电机线缆没有正确接地。4.电机烧坏。5.增益参数设置不合理，电机震荡。6.编码器接线问题。 | 1.参考规格，选择合适的制动电阻并合理设置相关参数。2.检查电机线缆是否正确连接，是否有短路、接不良、没有接地等情况存在。3.检查编码器线缆是否损坏。4.重新进行增益调整。5.更换电机。 |
| E.211.0输出对地短路引起母线电压过压 | 1.驱动器动力线缆(UVW)对地发生短路。2.电机对地短路。3.伺服驱动器故障。4.母线电压泄放点（P0219）设置过低。 | 1.重新接线或更换驱动器动力线缆。2.更换电机。3.正确设置母线电压泄放点（P0219）。 |
| E.212.0UVW相序错误 | 1.驱动器进行角度辨识时，驱动器和电机的UVW相序不匹配。 | 1.正确相序连接UVW线缆。 |
| E.213.0飞车故障 | 1.UVW相序接线错误。2.上电干扰导致电机转子初始相位错误。3.编码器型号错误或接线错误。4.垂直轴工况下，重力负载过大。 | 1.正确相序连接UVW线缆。2.重新上下电，重新进行角度自学习。3.更换为相互匹配的驱动器及电机，并正确设置电机型号。4.检查编码器及电机线缆是否正确连接。5.减小垂直轴负载，或提高刚性，或在不影响安全和使用的前提下，屏蔽该故障。 |
| E.214.0控制电源欠电压 | 1.控制电电源电压不稳或者掉电。2.控制电线缆接触不好。 | 1.检查接线或更换线缆。2.重新上电，若是异常掉电，需确保电源稳定。3.提高电源容量。 |
| E.216.0STO端子未连接 | 1.STO未连接导致STO生效。 | 1.STO正确接线。2.更换伺服驱动器。 |
| E.217.0三相输入缺一相 | 1.三相电规格输入驱动器连接单相输入。2.三相电输入接线不良。3.三相电压不平衡或三相电压过低。 | 1.检查三相电源接线。2.三相规格驱动器且允许单相运行(1kW以下)，关闭报警(设置P0800=2)。 |
| E.218.0伺服急停故障 | 1.DI功能2：紧急停机，被触发。2.后台通讯急停被触发。 | 1.检查运行模式，确认安全的前提下，解除DI刹车有效信号（急停有效信号解除后，该故障自动复位）。 |
| E.219.0驱动器温度过高故障 | 1.环境温度过高。2.过载后，通过关闭电源对过载故障复位，并反复多次。3.风扇损坏不能正常工作。4.伺服驱动器的安装方向、与其它伺服驱动器的间隔不合理。 | 1.改善伺服驱动器的冷却条件，降低环境温度。2.变更故障复位方法，过载后等待30s再复位。提高驱动器、电机容量，加大加减速时间，降低负载。3.根据伺服驱动器的安装标准进行安装。4.更换伺服驱动器。 |
| E.227.0UVW输出缺相 | 1.电机U或V或W相动力线断线。 | 1.检查电机动力线缆接线，重新接线，必要时更换线缆。 |
| E.228.0预充继电器未吸合 | 1.硬件损坏。 | 1.更换伺服驱动器。2.联系厂家技术支持。 |
| E.228.0预充电阻断路 | 1.预充电阻断路 | 1.联系厂家技术支持。 |
| E.411.0DI功能分配重复 | 1.DI功能分配时，同一功能重复分配给多个DI端子。 | 1.重新分配DI功能，避免重复。 |
| E.412.0DO功能分配超出定义范围 | 1.DO功能编号超出DO功能个数。 | 1.恢复出厂参数，重新上下电。 |
| E.413.0电流计算溢出故障 | 1.DQ轴电流溢出。 | 1.恢复出厂参数，重新上下电。2.更换伺服驱动器。 |
| E.414.0直流母线欠压故障 | 1.主回路电源不稳或者掉电。2.发生瞬间停电。3.运行中电源电压下降。4.三相电规格输入驱动器连接单相输入。 | 1.参照输入电源规格，调整或更换电源。2.提高电源容量。3.屏蔽缺相故障检测。 |
| E.415.0直流母线过压故障 | 1.主回路输入电压过高。2.电源处于不稳定状态，或受到了雷击影响。3.制动电阻失效。4.外接制动电阻阻值太大，最大制动能量不能完全被吸收。5.母线电压采样值有较大偏差。6.电机运行于急加减速状态，最大制动能量超过可吸收值。 | 1.参照输入电源规格，调整或更换电源。2.接入浪涌抑制器。3.参照外接制动电阻规格，选择合适的外接制动电阻。4.在允许情况下增大加减速时间。 |
| E.416.0速度超过最高转速 | 1.电机线缆U V W相序错误。2.电机或编码器参数设置不正确，比如极对数、编码器分辨率等。3.电机未进行角度辨识。4.输入指令超过了过速故障阈值。5.电机速度闭环超调。 | 1.按照正确U、V、W相序接线。2.正确设置电机参数或编码器分辨率。3.提高电源容量。4.重新进行增益调整。5.在满足需求的前提下，减小电子齿轮比。6.将速度限制阈值设置在过速阈值以内。 |
| E.417.0启动转速大于额定转速 | 1.驱动器上使能时电机实际转速大于额定转速。 | 1.复位故障，降低电机实际转速，重新运行。 |
| E.418.0伺服重复上使能 | 1.内部使能的情况下，通信伺服使能有效。 | 1.关闭上位机的伺服使能信号。 |
| E.419.0驱动器过载故障 | 1.参数设置错误。2.驱动器负载率过高，负载惯量偏大或机械卡顿。3.电机堵转。 | 1.根据驱动器型号设置正确的P0102。2.根据电流反馈效果合理调整参数。3.更换更大功率的驱动器。4.调整机械，解除机械卡顿现象。5.参考E.B11.0故障的处理方法。 |
| E.420.0分频输出频率过高故障 | 1.输出脉冲频率超过了硬件允许的频率上限(单路4MHz)。 | 1.减小编码器分频输出脉冲数(P1316)。2.使用双绞屏蔽线，防止干扰脉冲叠加在真实脉冲上，造成误报故障。 |
| E.421.0本地电子齿轮比设定错误 | 1.电子齿轮比设定值超过上述范围。2.参数更改顺序问题。 | 1. 参照电子齿轮比范围设定规格，设置齿轮比。2. 使用故障复位功能或重新上电即可。 |
| E.422.0全闭环使用多段绝对位置模式时不能进行内外环切换 | 1. 全闭环位置模式下，位置指令来源为内部位置指令，但使用了内外环切换模式。 | 1. 使用全闭环功能时，且位置指令来源为内部位置指令时，仅可以使用外部编码器反馈模式，即P2200仅能为1。 |
| E.423.0内环位置偏差过大 | 1.驱动器U V W输出缺相或相序接错。2.驱动器U V W输出断线或编码器断线。3.因机械因素导致电机堵转。4.伺服驱动器增益较低。5.位置指令增量过大。6.偏差阈值6065h/P0806过小。7.伺服驱动器/电机故障。 | 1.按照正确配线重新接线，或更换线缆。2.重新接线，必要时应更换全新线缆，并确保其可靠连接。3.排查机械因素。4.进行手动增益调整或者自动增益调整。5.增大位置指令的加减速斜坡。6. 增大偏差阈值6065h/P0806。7.更换伺服驱动器或电机。 |
| E.424.0位置指令多次一倍过速 | 1.位置指令增量过大。2.模式切换之前或伺服使能时，未将目标位置（607A 目标位置）与当前位置对齐。3.同步丢失，导致位置指令积累过大。4.电机速度限制错误。 | 1. 减小目标位置指令增量。2. 模式切换前或伺服使能时，将当前位置的数值赋给目标位置（607A 目标位置）。3. 确认电机最大转速是否符合应用要求。 |
| E.430.0龙门补偿数据写溢出 | 保留 | 保留 |
| E.710.0FPGA内部测速溢出 | 1.FPGA内部测速计算溢出。 | 1.检查确认编码器线缆连接正确。2.重新上下电再次尝试运行。3.更换电机或者驱动器。 |
| E.711.0离线惯量辨识故障 | 1.离线惯量辨识未完成。 | 1.联系厂家技术支持。 |
| E.712.0磁极辨识故障 | 1.电机初始磁极角度辨识失败。 | 1.电机轴断开连接，重新进行角度辨识。 |
| E.715.0参数辨识结果异常 | 1.辨识结果为0 | 1.联系厂家技术支持。 |
| E.716.0自调整增益过小 | 1.自调整增益过小 | 1.重新进行自调整；2.联系厂家技术支持。 |
| E.910.0上电时编码器参数校验异常 | 1.驱动器和电机类型不匹配。2.总线式增量编码器ROM中参数校验错误或未存放参数。 | 1.更换为相互匹配的驱动器及电机。2.检查编码器线缆，请使用我司标配的编码器线缆。3.编码器线和动力线分开走线。 |
| E.911.0(待详细定义区分) | 1.编码器接线错误。2.编码器线缆松动。3.编码器Z信号受干扰（EMC相关问题）。4.编码器故障。 | 1.按照正确的配线图重新接线。2.重新接线，并确保编码器接线端子紧固连接。3.使用我司标配的编码器线缆。4.更换伺服电机。 |
| E.912.0编码器参数校验错误 | 1.总线式增量编码器线缆断线、或松动。2.总线式增量编码器参数读写异常。 | 1.确认编码器线缆是否有误连接，或断线、接触不良等情况。2. 编码器线缆和动力线缆分开走线。3.更换伺服电机。 |
| E.913.0上电初始化读取初始角度错误 | 1.驱动器和电机类型不匹配。2.编码器线缆断线。 | 1.更换成匹配的电机和驱动器。2.更换完好的编码器线缆，并紧固连接。 |
| E.914.0Z信号线断线 | 1.编码器故障导致Z信号丢失。2.接线不良或接错导致编码器Z信号失。 | 1.更换伺服电机。2.检查编码器线是否接触良好，重新接线或更换线缆。 |
| E.916.0全闭环光栅尺断线 | 1.未禁止分频输出。2. 使用全闭环功能或者非标脉冲输入功能时，A+/A-、B+/B-、Z+/Z-任一组2路信号电平差不满足要求：电平差大于等于2V。 | 1. 将P1315的值设为2（分频或同步输出禁止）。2. 调整电平直至满足规格。 |
| E.917.0编码器电池故障 | 1.绝对值编码器，断电期间，未连接电池。2.编码器电池电压过低。 | 1.重新连接电池，或更换新的电池。2.设置P2005=1清除故障。 |
| E.918.0编码器多圈计数错误 | 1.编码器故障。 | 1.设置P2005=2清除故障，重新上电。2.更换电机。 |
| E.919.0编码器多圈计数器溢出 | 1. 绝对值编码器多圈计数溢出，多圈数据为32767或32768时才会报故障。此故障由伺服驱动器检测报出，而非编码器报出。 | 1.设置P2005=2清除编码器多圈数据，重新上电。 |
| E.922.0编码器过热警告 | 1.编码器的温度过高。 | 1.驱动器停止运行一段时间。2.确保编码器通风良好，降低环温。 |
| E.B10.0电机过载故障 | 1.电机接线、编码器接线错误、不良。2.负载太重，电机输出有效转矩超过额定转矩，长时间持续运转。3.加减速太频繁或者负载惯量很大。4.增益调整不合适或刚性太强。5.驱动器或者电机型号设置错误。6.因机械因素而导致电机堵转，造成运行时的负载过大。 | 1.正确设置驱动器型号和电机型号能参数。2.使用我司标配线缆，参考接线图，检查线缆连接。3.更换大容量驱动器及匹配的电机，或减轻负载，加大加减速时间。4.增大单次运行中的加减速时间。5.重新调整增益。6.排除机械因素。 |
| E.B11.0电机堵转保护 | 1.驱动器U V W输出缺相、断线、相序接错。2.电机参数设置不正确，比如极对数等。3.电机未进行角度辨识。4.通讯指令受干扰。5. 因机械因素导致电机堵转。 | 1.按照正确配线重新接线，或更换线缆。2.正确设置电机参数。3.检查上位机与伺服通讯线路是否受到干扰。4.排查机械因素是否存在卡死、偶尔卡顿、偏心状况。 |
| E.B13.0电机振动过大 | 1.电机振动过大 | 1.调整增益参数2.开启振动抑制 |
| E.B14.0位置异常检测 |  |  |
| E.B15.0热敏电阻断线或热敏电阻未连接 | 1.热敏电阻断线或热敏电阻未连接 | 1.检查热敏电阻及其连接线。 |
| E.D15.0软限位上下限设置错误 | 1.软件限位下限值大于等于软限位上限值。 | 1.重新设定参数，确保607D-01h小于607D-02h（P0B45小于P0B47）。 |
| E.D16.0原点偏置超出软限位范围 | 1.原点偏置在软限位位置范围之外。 | 1.重新设定参数，合理设置607D-01h和607D-02h（P0B45和P0B47）。 |
| E.D20.0EtherCAT通讯断线 | 保留 | 保留 |
| E.D21.0EtherCAT通讯禁止 | 保留 | 保留 |
| E.D22.0EtherCAT通讯连接超时 | 保留 | 保留 |
| E.D23.0EtherCAT扩展卡通讯超时 | 保留 | 保留 |
| E.D24.0EtherCAT站点名冲突 | 保留 | 保留 |
| E.D25.0EtherCAT站点名设置错误 | 保留 | 保留 |
| E.D26.0EtherCAT通讯异常 | 1.伺服处于使能状态，由于主站误操作或人为误操作，导致EtherCAT网络状态由OP切到其他状态时，网络状态切换异常。 | 1.检查上位机网络状态切换程序。 |
| E.D27.0EtherCAT系统参数错误 | 保留 | 保留 |
| E.D28.0EtherCAT组态错误 | 保留 | 保留 |
| E.D29.0EtherCAT未烧录XML文件 | 1. EEPROM中未烧录XML文件。2. EEPROM中XML文件被异常修改。 | 1.烧录XML文件。 |
| E.D30.0EtherCAT通讯初始化失败 | 1.未烧录FPGA软件。2.伺服驱动器故障。 | 1.联系厂家，烧录FPGA软件。2.更换伺服驱动器。 |
| E.D31.0EtherCAT同步周期设置错误 | 1.网络切换到运行模式后，同步周期不是125µs或者250µs的整数倍。 | 1.修改同步周期的设定值为125µs或者250µs的整数倍。 |
| E.D32.0EtherCAT同步信号偏差过大 | 1.同步周期误差值超过阈值，控制器同步周期误差大。 | 1.增大厂家参数P0A32。 |