### 基本增益参数

在极致的性能要求场景下，可以手动微调增益。通过更细致的调整，优化调试效果。

伺服系统由三个控制环路构成，从内向外依次是电流环、速度环和位置环，基本控制框图如下图所示。

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/68662f722beb1.png)

越是内侧的环路，要求响应性越高。一般内环带宽要设置为外环带宽4倍以上，例如，电流环带宽2000Hz，速度环带宽设置不应高于500Hz，位置环带宽设置不应高于125Hz。调试过程中，应尽量遵守该原则，否则可能导致系统不稳定！

伺服驱动器默认的电流环增益已确保了响应性，一般无需调整，需要调整的只有位置环增益、速度环增益及其他辅助增益。因此，位置控制模式下进行增益调整时，如果想要提高位置响应性能，为保证系统稳定，首先提高速度环增益，并确保环路之间内环高于外环带宽的4倍原则，然后再提升位置环增益，减小位置跟踪误差。必须保证由内而外的次序，进行环路增益调整。

基本增益参数调整方法如下。

| **步骤** | **功能码** | **名称** | **调整说明** |
|---|---|---|---|
| 1 | P06.00 | 速度比例增益1 | 参数作用：    决定速度环能够跟随的变化的速度指令最高频率。    在负载惯量比平均值(P06.10)设置正确的前提下，可认为：速度环最高跟随频率= P06.00  ![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/68663024d1301.png)  调整方法：    在不产生噪声、振动的情况下，增大此参数，可加快定位时间，带来更好的速度稳定性和跟随性；    产生噪音，则降低参数设定值； |
| 2 | P06.01 | 速度积分增益1 | 参数作用：消除速度环偏差。  ![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/6866304163bbe.png)  调整方法：建议按以下关系取值：500≤P06.00×P06.01≤1000   例如，速度环增益P06.00=40.0Hz时，速度环积分时间常数应满足：12.50ms≤P06.01≤25.00ms。   减小设定值可加强积分作用，加快定位时间，但设定值过小易引起机械振动。设定值过高，将导致速度环偏差总不能归零。   当P06.01=512.00ms时，积分无效。 |
| 3 | P06.02 | 位置比例增益1 | 参数作用：决定位置环能够跟随的变化的位置指令最高频率。   位置环最高跟随角频率=P06.02  ![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/686630939c5e7.png)  调整方法：为保证系统稳定，应保证速度环最高跟随频率是位置环最高跟随频率的3~5倍，因此：  ![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/686630b4cf3c4.png)  例如，速度环增益P06.00=40.0Hz时，位置环增益应满足：50.2Hz≤P06.02≤83.7Hz。根据定位时间进行调整。加大此参数，可加快定位时间，并提高电机静止时抵抗外界扰动的能力。设定值过高可能导致系统不稳定，发生振荡。 |
| 4 | P07.02 | 转矩滤波1 | 参数作用：消除高频噪声，抑制机械共振。![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/686630c746d33.png)   调整方法：应保证转矩指令低通滤波器的截止频率高于速度环最高跟随频率的4倍，因此：  ![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/686630e7ab066.png)  例如，速度环增益P06.00 =40.0Hz时，转矩指令滤波时间常数应满足：P07.02≤1.00ms。增大P06.00发生振动时，可通过调整P07.02抑制振动，；设定值过大，将导致电流环的响应降低；需抑制停机时的振动，可尝试加大P06.00，减小P07.02；电机停止状态振动过大，可尝试减小P07.02设定值。 |

位置环增益Kp，速度环增益Kv，速度环积分Ti，转矩低通滤波时间Tf，是伺服控制基本环路增益参数，四个基本增益参数之间需要保持一定的关系，才能保证整个伺服系统在稳定性和高性能之间取得平衡，四个基本参数之间数学关系如下：

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/6866311d56f07.png)

下面结合实验波形，分别介绍一下，在位置控制模式下，基本增益参数的作用。

**无速度积分位置跟踪波形**

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/6866313d2d8c9.png)

**有速度积分位置跟踪波形**![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/6866314aa13c6.png)

通过对比图，可以发现当只有位置增益和速度增益系数，无速度积分时，可实现快速定位，有稳态误差，提高环路增益可以降低稳态误差；当有速度积分时，无稳态误差，但是整定时间变长。

**有转矩低通滤波 Tf=4ms** ![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/686631897f439.png)

**有转矩低通滤波 Tf=0.2ms**

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/686631beb03e5.png)

通过对比图可以发现，增加转矩低通滤波可以消除转矩振荡，但是滤波转折频率较低，相位滞后增大，无法提高增益，整定时间变长。

通过对比图可以发现，通过合理设置转矩低通滤波，可以消除转矩振荡，同时也保证了位置快速整定，在快速性与稳定性之间取得了比较好的平衡。

增益类与转矩控制参数功能码

| **功能码** | **P06.00-速度比例增益1** | **P06.01-速度积分增益1** | **P06.02-位置比例增益1** | **P07.02-转矩滤波1** |
|---|---|---|---|---|
| 单位 | Hz | ms | Hz | ms |
| 默认值 | 25.0 | 31.83 | 40.0 | 0.79 |
| 最小值 | 0.1 | 0.15 | 0.1 | 0.00 |
| 最大值 | 2000.0 | 512.00 | 2000.0 | 30.00 |
| 设定、生效方式 | 停机设定/立即生效 | 停机设定/立即生效 | 停机设定/立即生效 | 停机设定/立即生效 |
| 注释 | - |

---

### 前馈控制

#### 速度前馈

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/686632583faab.png)

在位置控制模式下，通过内部位置指令直接计算出动作所需的理论速度指令，并与位置反馈闭环计算得到的速度指令相加，施加到速度调节器指令输入，与单纯反馈控制比，可大幅降低位置跟踪误差，提高响应性能。因此，使用速度前馈功能，可以提高速度指令响应，减小固定速度时的位置偏差。

理论上，位置偏差与位置环增益、速度前馈增益之间的关系，如下所示。如果将速度前馈增益设置为100%，理论上位置偏差将变为零，但是过大的前馈增益系数将引起加减速段过大的速度过冲。

当位置指令更新周期小于伺服控制周期时，速度前馈的微分操作，会引起较大的微分误差，此误差会转化为高频转矩指令成分，进而诱发运行过程中的电磁噪音，此时请使用位置指令滤波器（FIR滤波器或者滑动均值滤波），或者增大速度前馈滤波值。

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/6866326aa151f.png)

速度前馈功能操作步骤：

A)设置速度前馈信号来源

将P13.12(速度前馈控制选择)置为非0值，速度前馈功能生效，速度前馈信号来源可选择内部和外部，具体如下表所示。

| **功能码** | **名称** | **设定值** | **备注** |
|---|---|---|---|
| P13.12 | 速度前馈控制选择 | 0：无速度前馈 | - |
| 1：内部速度前馈 | 将位置指令对应的速度信息作为速度前馈信号来源。 |
| 2：将AI1用作速度前馈输入 | 将AI1作为速度前馈信号的来源。 |
| 3：将AI2用作速度前馈输入 | 将AI2作为速度前馈信号的来源。 |

B)设置速度前馈参数

包括速度前馈比例增益(P6.08)和速度前馈滤波时间 (P07.06)。

| **功能码** | **名称** | **调整说明** |
|---|---|---|
| P07.06 | 速度前馈滤波时间 | 减小滤波时间，可抑制加减速时的速度过冲；   增大滤波时间，可抑制位置指令更新周期与驱动器控制周期相比较长、位置指令的脉冲频率不均匀等情况下的噪音，抑制定位完成信号的抖动； |
| P06.08 | 速度前馈比例增益 |  |

#### 转矩前馈

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/68663470ec3bd.png)

位置控制模式，采用转矩前馈，可以提高动态速度响应，减小固定加减速时的位置偏差； 使用转矩前馈，需要设置正确的负载转矩惯量比，请使用机械负载识别结果。转矩前馈增益设置为非零值，转矩前馈功能即启用，通过提高转矩前馈增益，可将恒定加减速过程中的位置偏差控制到0附近，在没有外部力矩干扰的情况下，可完美跟踪梯形运动曲线。

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/68663492c547d.png)

转矩前馈功能操作步骤：

A)设置转矩前馈信号来源

将P14.11 (转矩前馈选择)置为非零值，转矩前馈功能生效，前馈信号来源可选择内部和外部，具体如下表所示。

| **功能码** | **名称** | **设定值** | **备注** |
|---|---|---|---|
| P14.11 | 转矩前馈控制选择 | 0：无转矩前馈 | - |
| 1：内部转矩前馈 | 将速度指令作为转矩前馈信号来源。位置控制模式下，速度指令来自于位置控制器的输出。 |

B)设置转矩前馈参数

包括转矩前馈比例增益(P06.09)和转矩前馈滤波时间(P07.07)。

| 功能码 | 名称 | 调整说明 |
|---|---|---|
| P07.07 | 转矩前馈滤波时间 | 参数作用：   增大P06.09，可提高响应，但加减速时可能产生过冲；减小P07.07，可抑制加减速时的过冲；增大P07.07，可抑制噪音；  调整方法：   调整时，首先，保持P07.07为默认值；然后，将P06.09设定值由0逐渐增大，直至某一设定值下，转矩前馈取得效果。调整时，应反复调整P07.07和P06.09，寻找平衡性好的设定 |
| P06.09 | 转矩前馈比例增益 |

---

### 二自由度控制

非转矩控制模式下，可使用二自由度控制系数改善控制效果，设置为100%，为普通PI控制模式；设为非100%即为二自由度控制，可用来增加对外力的抵抗能力以及改善速度响应波形。

下图是二自由度控制系数对速度上升缓慢以及定位完成缓慢的改善。

![](https://resource.helplook.net/docker_production/3648ne/article/fTeVh3J4/68663533c70fb.png)

二自由度控制通过对速度环控制方法进行调整，增强速度环的抗干扰能力，改善对速度指令的跟随性。

| **功能码** | **名称** | **调整说明** |
|---|---|---|
| P06.12 | 二自由度前馈系数 | 参数作用：非转矩控制模式下，改变速度环的控制方法。   调整方法：P06.12设置过小，速度环响应变慢；速度反馈存在过冲时，将P06.12由100.0逐渐减小，直至某一设定值下，二自由度控制取得效果。P06.12 =100.0时，速度环控制方法不变，为默认的比例积分控制。 |